function h=gf_pdeplot(mf,U,varargin)
% this function is used to plot a general pde solution
nargs = nargin;
if nargs<2,
  error('Too few input arguments')
end

interpolated=0;
nrefine=8;
title='';
xyplot=1;
showmesh=0;

k=1;

while (k<=length(varargin))
  switch varargin{k}
   case 'xydata'
    xyplot=1; vectordata=0;
   case 'flowdata'
    xyplot=1; vectordata=1;
   case 'zdata'
    xyplot=0; vectordata=0;
   case 'refine'
    if (k<length(varargin)), nrefine=varargin{k+1}; k=k+1;
    else, error('bad argument'); 
    end
   case 'interpolated'
    interpolated=1
   case 'mesh'
    showmesh=1
   otherwise
    error(['Unknown parameter: ' varargin{k}])
  end
  k=k+1;
end

is_hold = ishold;

nb_dof=gf_nb_dof(mf);
if (nb_dof < 0), error('invalid finite element mf argument'); end

if (size(U,1) ~= nb_dof),
  error(['wrong dimensions for U, should' ...
	 ' have ' int2str(nb_dof) 'rows']); 
end

if (size(U,2) == 1), vectordata=0;
elseif (size(U,2) == 2), vectordata=1;
else error(['U should have 1 column (scalar data) or 2 columns (vector data)']); end;

% interpolate the solution on a refined P1 mesh
P=gf_get_refined_P1_tri_mesh(mf, U(:,1), nrefine);
if (vectordata),
  Ptmp=gf_get_refined_P1_tri_mesh(mf, U(:,1), nrefine);
  P(10:12,:)=Ptmp(7:9,:);
end

ax = newplot;
if (xyplot), view(2); else view(3); end;

if (vectordata==0),
  if (interpolated==0),
    V=mean(P(7:9,:));
  else
    V=P(7:9,:);
  end

  if (xyplot),
    hh=patch(P(1:2:6,:),P(2:2:6,:), V, 'Parent', ax, 'Erasemode','normal','Edgecolor','none');
  else
    hh=patch(P(1:2:6,:),P(2:2:6,:), V, V, 'Parent', ax, 'Erasemode','normal','Edgecolor','none');
  end;
  if (showmesh), hold on;draw_mesh(mf); end;
else
  B=gf_get_faces_boundary_numbers(mf);
  D=gf_get_deformed_mesh_points(mf,2);
  error('vector data still not supported');
end
  
if (is_hold)
  hold on;
else
  hold off;
end;