/* *********************************************************************** */
/*                                                                         */
/* Library : Matlab Command (matlabcom)                                    */
/* File    : simplex_exact_integration.C :                                 */
/*     									   */
/*                                                                         */
/* Date : October 11, 2001.                                                */
/* Author : Yves Renard, Yves.Renard@gmm.insa-tlse.fr                      */
/*                                                                         */
/* *********************************************************************** */
/*                                                                         */
/* Copyright (C) 2001  Yves Renard.                                        */
/*                                                                         */
/* This file is a part of GETFEM++                                         */
/*                                                                         */
/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; version 2 of the License.                 */
/*                                                                         */
/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */
/*                                                                         */
/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software Foundation, */
/* Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.         */
/*                                                                         */
/* *********************************************************************** */

#include "mex.h"
#include <matlabint_pfi.h>

/**@name i = simplex_exact_integration(n)
 * return an identifier on the structure of the exact integration on a simplex
 * of dimension n.
 */
//@{
//@}

#define id_type matlabint::id_type

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
  if (nrhs != 1)
    mexErrMsgTxt("Wrong number of input arguments.");
  else if (nlhs != 1)
    mexErrMsgTxt("Wrong number of output argument.");

  void *q1 = mxGetData(prhs[0]);
  id_type a;  
  switch (mxGetClassID(prhs[0]))
  {
    case mxCHAR_CLASS   : a = id_type(*((char *)q1));             break;
    case mxDOUBLE_CLASS : a = id_type(*((double *)q1));           break;
    case mxSINGLE_CLASS : a = id_type(*((float *)q1));            break;
    case mxINT8_CLASS   : a = id_type(*((dal::int8_type *)q1));   break;
    case mxUINT8_CLASS  : a = id_type(*((dal::uint8_type *)q1));  break;
    case mxINT16_CLASS  : a = id_type(*((dal::int16_type *)q1));  break;
    case mxUINT16_CLASS : a = id_type(*((dal::uint16_type *)q1)); break;
    case mxINT32_CLASS  : a = id_type(*((dal::int32_type *)q1));  break;
    case mxUINT32_CLASS : a = id_type(*((dal::uint32_type *)q1)); break;
    default : mexErrMsgTxt("Argument should be numeric.");
  }

  if (a > 256)
    mexErrMsgTxt("The argument is out of range.");
  int j = 1;
  plhs[0] = mxCreateNumericArray(1, &j, mxUINT32_CLASS, mxREAL);
  *((id_type *)(mxGetData(plhs[0])))
    = matlabint::ind_pfi(bgeot::simplex_poly_integration(a))+MATLABINT_PFI_MASK;
 
}
