/* *********************************************************************** */
/*                                                                         */
/* Library : Matlab Command (matlabcom)                                    */
/* File    : convex_product_approx_integration.C                           */
/*     									   */
/*                                                                         */
/* Date : October 11, 2001.                                                */
/* Author : Yves Renard, Yves.Renard@gmm.insa-tlse.fr                      */
/*          Julien Pommier, pommier@gmm.insa-tlse.fr                       */
/*                                                                         */
/* *********************************************************************** */
/*                                                                         */
/* Copyright (C) 2001  Yves Renard.                                        */
/*                                                                         */
/* This file is a part of GETFEM++                                         */
/*                                                                         */
/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; version 2 of the License.                 */
/*                                                                         */
/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */
/*                                                                         */
/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software Foundation, */
/* Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.         */
/*                                                                         */
/* *********************************************************************** */

#include "mex.h"
#include <matlabint_pfi.h>
#include <matlabint_misc.h>

/**@name i = convex_product_approx_integration(fi1,fi2)
 * return an identifier on the structure of the approximative integration on
 * the tensorail product of 2 approx integration methods pi1 and pi2
 */
//@{
//@}

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
  if (nrhs != 2)
    mexErrMsgTxt("Wrong number of input arguments.");
  else if (nlhs != 1)
    mexErrMsgTxt("Wrong number of output argument.");

  getfem::pintegration_method pfi1 = check_for_fem_interpolation_arg(prhs[0]);
  getfem::pintegration_method pfi2 = check_for_fem_interpolation_arg(prhs[1]);

  if (pfi1.is_ppi || pfi2.is_ppi) {
    mexErrMsgTxt("At least on a the integration method is not a approximate one");
  }

  int j = 1;
  plhs[0] = mxCreateNumericArray(1, &j, mxUINT32_CLASS, mxREAL);
  *((matlabint::id_type *)(mxGetData(plhs[0])))
    = matlabint::ind_pfi(bgeot::convex_product_approx_integration(pfi1.method.pai,
								  pfi2.method.pai))+MATLABINT_PFI_MASK;
}
