/* *********************************************************************** */
/*                                                                         */
/* Library : Matlab Command (matlabcom) version 1.0                        */
/* File    : assem_linear_elasticity.C : .                                 */
/*     				          		     */
/*                                                                         */
/* Date : March 2002001.                                                   */
/* Author : J. Pommier pommier@gmm.insa-tlse.fr                            */
/*                                                                         */
/* *********************************************************************** */
/*                                                                         */
/* Copyright (C) 2001  Yves Renard.                                        */
/*                                                                         */
/* This file is a part of GETFEM++                                         */
/*                                                                         */
/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; version 2 of the License.                 */
/*                                                                         */
/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */
/*                                                                         */
/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software Foundation, */
/* Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.         */
/*                                                                         */
/* *********************************************************************** */

#include "matlabint_misc.h"


/**@name B = mesh_fem_get_interpolatation_points(mesh_fem mf)
 * 
 * get the list of interpolation points of the mesh_fem
 * output: B is a matrix [Nxn_points] containing the point locations
 */
//@{
//@}
void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
  getfem::mesh_fem *mf;
  int warn_cnt  = 0;
  
  double *pr;

  //  const double * vec_lambda, * vec_mu;
    

  if (nrhs != 1) 
    mexErrMsgTxt("Wrong number of input argument. [arg1 : mesh_fem]");
  else if (nlhs != 1)
    mexErrMsgTxt("Wrong number of output argument.");

  mf = check_for_mesh_fem_arg(prhs[0]);
  if (mf->nb_dof() <= 0) {
    mexErrMsgTxt("nothing to interpolate");
  }

  dal::bit_vector nn = mf->convex_index();
  getfem::size_type cv;
  for (cv << nn; cv != getfem::ST_NIL; cv << nn) {
    /* on pourrait aussi tester que la fem est la mme sur tous les lments */
    if (!mf->fem_of_element(cv)->is_lagrange() && warn_cnt==0) {
      mexPrintf("warning: some elements are *NOT* lagrange elements\n");
      warn_cnt++;
    }
  }
  
  plhs[0] = mxCreateDoubleMatrix(mf->linked_mesh().dim(),mf->nb_dof(), mxREAL);

  pr = mxGetPr(plhs[0]);

  for (int i=0; i < mf->nb_dof(); i++) {
    getfem::base_node bn = mf->point_of_dof(i);
    for (int j=0; j < mf->linked_mesh().dim(); j++) {
      pr[i*(mf->linked_mesh().dim()) + j] = bn[j];
    }
    /*
    mexPrintf("pt(%3d) : [%f %f]\n", i, bn[0], bn[1]);
    */
  }
}
