function [Q,G,H,R,F]=gf_assemb(b, e, mf_u, mf_d, f_expr)
  nb_boundaries = size(b,2);
  
  xyeval = gf_get_interpolation_pts(mf_d);

  nbdof = size(xyeval,2);
  N=b(1,1); % dimension of the system (1->scalar, 2->vector 2D)

  
  for bnum=1:nb_boundaries,
    bnum
    %ignores
    if (b(1,bnum)==0), continue; end;
    
    %select edges which belong to
    %boundary 'bnum'
    E=e(:, find(e(5,:)==bnum))
    set_boundary_number(bnum, mf_d, E(1:2,:));
    set_boundary_number(bnum, mf_u, E(1:2,:));

    M = b(2,bnum); % number of dirichlet conditions (0,1,..N)
    if (M>N), disp('invalid geometry matrix'); return; end;
    
    clear qexpr gexpr;
    pos_len = 3;
    pos = 3+N*N+N+M*N+M;
    
    % reading Q expressions
    for j=1:N,
      for i=1:N,
	len=b(pos_len,bnum);
	qexpr{i,j}=char(b(pos:(pos+len-1), bnum)');
	pos_len = pos_len+1;
	pos = pos+len;
      end;
    end;
    
    
    % reading G expressions
    for i=1:N,
      len=b(pos_len,bnum);
      gexpr{i}=char(b(pos:(pos+len-1), bnum)');
      pos_len = pos_len+1;
      pos = pos+len;
    end;      
    
    
    % reading H expression
    for j=1:N,
      for i=1:M,
	len=b(pos_len,bnum);
	hexpr{i,j}=char(b(pos:(pos+len-1), bnum)');
	pos_len = pos_len+1;
	pos = pos+len;	
      end;
    end;
    
    
    % reading R expressions
    for i=1:M,
      len=b(pos_len,bnum);
      rexpr{i}=char(b(pos:(pos+len-1), bnum)');
      pos_len = pos_len+1;
      pos = pos+len;	
    end;
    
    
    % computations of expressions on the dof
    vQ = zeros(N,N,nbdof);
    for i=1:N,
      for j=1:N,
	vQ(i,j,:) = eval_expr(xyeval, qexpr{i,j});
      end;
    end;
    vG = zeros(N,nbdof);
    for i=1:N,
      vG(i,:) = eval_expr(xyeval, gexpr{i})';
    end;
    vH = zeros(N,N,nbdof);
    for i=1:M,
      for j=1:N,
	vH(i,j,:) = eval_expr(xyeval, hexpr{i,j});
      end;
    end;
    vR = zeros(N,nbdof);
    for i=1:M,
      vR(i,:) = eval_expr(xyeval, rexpr{i})';
    end;

    size(vQ)
    size(vG)
    [bQ,bG,bH,bR] = gf_assem_general_boundary_cond(bnum, mf_u, mf_d, ...
						   reshape(vQ,N*N,nbdof), ...
						   reshape(vG,N,nbdof), ...
						   reshape(vH,N*N,nbdof), ...
						   reshape(vR,N, ...
						  nbdof));
    
    
    
    
%    disp('grosse bidouille !!!!!!!!!!!!!!!');
%    Z=find(diag(bH));
%    bH=sparse(gf_nb_dof(mf_u)*2,gf_nb_dof(mf_u)*2);
%    bH(Z,Z)=speye(length(Z)); 
%    bR=zeros(2,gf_nb_dof(mf_u));
%    xyeval2 = gf_get_interpolation_pts(mf_u);
%    for i=1:M,
%      bR(i,:) = eval_expr(xyeval2, rexpr{i})';
%    end;
%    bR=bR(:);
%    tmp=bR;
%    bR=zeros(size(bR)); bR(Z)=tmp(Z);
%    size(bH)
    
    
    
    
    if (bnum ~= 1),
      Q=Q+bQ; G=G+bG; H=H+bH; R=R+bR;
    else
      Q=bQ; G=bG; H=bH; R=bR;
    end
  end;

  % check for volumic source term
  if (nargin == 5 & nargout == 5),
    Fd = zeros(N*nbdof,1);
    for i=1:N
      Fd(i:N:length(Fd)) = eval_expr(xyeval, f_expr(i,:));
    end;
    F=gf_assem_volumic_term(mf_u,mf_d,Fd);
    F=F(:);
  end;
  
function V=eval_expr(xypos, expr)
  disp(['expr=' expr]);
  if (size(xypos,1) ~= 2), disp('size error'); keyboard; end;
  V=zeros(size(xypos,2),1);
  x=xypos(1,:); y=xypos(2,:);
  eval(['e=' expr ';']); V(:) = e(:);
%  for i=1:size(xypos,2)
%    x=xypos(1,i); y = xypos(2,i);
%    eval(['e=' expr ';']);
%    V(i)=e;
%  end;
  