/* *********************************************************************** */
/*                                                                         */
/* Library : Matlab Command (matlabcom) version 1.0                        */
/* File    : gf_assem_volumic_src_term.C                                   */
/*     				          		                   */
/*                                                                         */
/* Date : March 2002001.                                                   */
/* Author : J. Pommier pommier@gmm.insa-tlse.fr                            */
/*                                                                         */
/* *********************************************************************** */
/*                                                                         */
/* Copyright (C) 2001  Yves Renard.                                        */
/*                                                                         */
/* This file is a part of GETFEM++                                         */
/*                                                                         */
/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; version 2 of the License.                 */
/*                                                                         */
/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */
/*                                                                         */
/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software Foundation, */
/* Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.         */
/*                                                                         */
/* *********************************************************************** */

#include "matlabint_misc.h"

using namespace getfem;


/**@name [Fu] = assem_general_boundary_condition(mesh_fem mf_u, mesh_fem mf_d, vec Fd)
 * 
 * assemblate a volumic source term
 */
//@{
//@}
void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
  mesh_fem *mf_u, *mf_d;
  size_type dim;
  VECbidon Fd, Fu;

  if (nrhs != 3) 
    mexErrMsgTxt("Wrong number of input argument");
  else if (nlhs > 1)
    mexErrMsgTxt("Wrong number of output argument");

  mf_u = check_for_mesh_fem_arg(prhs[0]);
  mf_d = check_for_mesh_fem_arg(prhs[1]);
 
  Fd.ve = check_for_node_values(prhs[2], mf_d, 0, &dim);

  plhs[0] = mxCreateDoubleMatrix(dim, mf_u->nb_dof(), mxREAL);
  assert(plhs[0] != 0);
  Fu.ve = mxGetPr(plhs[0]);

  assembling_volumic_source_term<VECbidon,VECbidon>(Fu, *mf_u, *mf_d, Fd, dim);
}
