/* *********************************************************************** */
/*                                                                         */
/* Library : Matlab Command (matlabcom)                                    */
/* File    : assem_mass_matrix.C : .                                       */
/*     								           */
/*                                                                         */
/* Date : July 2002.                                                       */
/* Author : Y. Renard Yves.Renard@gmm.insa-tlse.fr                         */
/*                                                                         */
/* *********************************************************************** */
/*                                                                         */
/* Copyright (C) 2001  Yves Renard.                                        */
/*                                                                         */
/* This file is a part of GETFEM++                                         */
/*                                                                         */
/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; version 2 of the License.                 */
/*                                                                         */
/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */
/*                                                                         */
/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software Foundation, */
/* Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.         */
/*                                                                         */
/* *********************************************************************** */

#include "matlabint_misc.h"
 
/**@name k = assem_mass_matrix(mf, mf_data, data_lambda, data_mu)
 * assembles mass matrices
 */
//@{
//@}
void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
  getfem::mesh_fem *mf_u;

  if (nrhs != 2) 
    mexErrMsgTxt("Wrong number of input argument.");
  else if (nlhs != 1)
    mexErrMsgTxt("Wrong number of output argument.");

  mf_u = check_for_mesh_fem_arg(prhs[0]);
  int dim = check_for_scalar_integer_arg(prhs[1], 2, "dimension");
  
  //  matlabint::smatrix<double> M(mf_u->nb_dof(), mf_u->nb_dof());
 
  bgeot::smatrix<getfem::scalar_type> M(mf_u->nb_dof() * dim, 
					mf_u->nb_dof() * dim);
  
  getfem::mass_matrix(M, *mf_u, dim);
  plhs[0] = convert_to_mxSparse(M);
}


