/* *********************************************************************** */
/*                                                                         */
/* Library : Matlab Command (matlabcom)                                    */
/* File    : assem_linear_elasticity.C : .                                 */
/*     								           */
/*                                                                         */
/* Date : February 2002.                                                   */
/* Author : J. Pommier pommier@gmm.insa-tlse.fr                            */
/*                                                                         */
/* *********************************************************************** */
/*                                                                         */
/* Copyright (C) 2001  Yves Renard.                                        */
/*                                                                         */
/* This file is a part of GETFEM++                                         */
/*                                                                         */
/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; version 2 of the License.                 */
/*                                                                         */
/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */
/*                                                                         */
/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software Foundation, */
/* Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.         */
/*                                                                         */
/* *********************************************************************** */

#include "matlabint_misc.h"
 
/**@name k = assem_linear_elasticity(mf, mf_data, data_lambda, data_mu)
 * assembles elementary matrices for linear elasticity (and partialy stockes)
 */
//@{
//@}
void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
  getfem::mesh_fem *mf_u, *mf_d;

  VECbidon vec_lambda, vec_mu;

  //  const double * vec_lambda, * vec_mu;
    

  if (nrhs != 4) 
    mexErrMsgTxt("Wrong number of input argument.");
  else if (nlhs != 1)
    mexErrMsgTxt("Wrong number of output argument.");

  mf_u = check_for_mesh_fem_arg(prhs[0]);
  mf_d = check_for_mesh_fem_arg(prhs[1]);

  vec_lambda.ve = check_for_node_values(prhs[2], mf_d);
  vec_mu.ve = check_for_node_values(prhs[3], mf_d);
  
  //  matlabint::smatrix<double> M(mf_u->nb_dof(), mf_u->nb_dof());
 
  bgeot::smatrix<getfem::scalar_type> M(mf_u->nb_dof() * mf_u->linked_mesh().dim(), 
			       mf_u->nb_dof() * mf_u->linked_mesh().dim());
  

  getfem::assembling_rigidity_matrix_for_linear_elasticity<bgeot::smatrix<getfem::scalar_type>, VECbidon>
    (M, *mf_u, *mf_d, vec_lambda, vec_mu);
  plhs[0] = convert_to_mxSparse(M);
}


