function h=draw_mesh(i,numero)
%       H=draw_mesh(i) displays a mesh. draw_mesh(i, 'vertices') displays also
%       vertices numbers. draw_mesh(i, 'nodes', mfi) displays also finite
%       element nodes, wher pfi is a identifier of a mesh fem.
%       draw_mesh(i, 'convexes') displays also convexes numbers.
%
%       A. Huard, Y. Renard
%       $Date: 2002/04/26 14:59:11 $
M = points_of_mesh(i);
n = size(M,1);
if (n > 3)
  error('Sorry, No drawing for mesh of dimension higher than 3');
end

vertices = 0;
nodes = 0;
convexes  = 0;
if nargin > 1
  switch numero
  case 'vertices'
        vertices =1;
  case 'convexes'
       convexes = 1;
  case 'nodes'
       nodes = 1;
  end;
end;

E = mesh_to_edges(i);
nbpt = size(M,2);
nbe = size(E,2);
xM = max(M(1,:));
xm = min(M(1,:));
ecartx = (xM-xm);
if (ecartx == 0)
     ecartx = 1.0;
end

if (n > 1)
  Y = [M(2,E(1,:)); M(2,E(2,:))];
  yM = max(M(2,:));
  ym = min(M(2,:));
  ecarty = (yM-ym);
  if (ecarty == 0)
     ecarty = 1.0;
  end
end

if (n > 2)
  Z = [M(3,E(1,:)); M(3,E(2,:))];
  zM = max(M(3,:));
  zm = min(M(3,:));
  ecartz = (yM-ym);
  if (ecarty == 0)
     ecarty = 1.0;
  end
end


X = [M(1,E(1,:)); M(1,E(2,:))];
if (n == 1)
  Y = X * 0;
  h = plot(X, Y, 'b-+');
  if vertices
     text(M(1,:)+ecartx/100, 0 * M(1,:), num2str( (1:nbpt)'));
  end;
else if (n == 2)
  h = plot(X, Y, 'b-+');
  if vertices
    text(M(1,:)+ecartx/100, M(2,:)+ecarty/100, num2str( (1:nbpt)'));
  end;
  axis([(xm-ecartx/10) (xM+ecartx/10) (ym-ecarty/10) (yM+ecarty/10)]);
else
  h = plot3(X, Y, Z, 'b-+');
  if vertices
    text(M(1,:)+ecartx/100, M(2,:)+ecarty/100, M(3,:)+ecartz/100, num2str( (1:nbpt)'));
  end
  axis([(xm-ecartx/10) (xM+ecartx/10) (ym-ecarty/10) (yM+ecarty/10) (zm-ecartz/10) (zM+ecartz/10)]);
end
end
