/* *********************************************************************** */
/*                                                                         */
/* Library : Matlab Command (matlabcom) version 1.0                        */
/* File    : del_mesh.C : delete a mesh variable.                          */
/*     									   */
/*                                                                         */
/* Date : September 27, 2001.                                              */
/* Author : Yves Renard, Yves.Renard@gmm.insa-tlse.fr                      */
/*                                                                         */
/* *********************************************************************** */
/*                                                                         */
/* Copyright (C) 2001  Yves Renard.                                        */
/*                                                                         */
/* This file is a part of GETFEM++                                         */
/*                                                                         */
/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; version 2 of the License.                 */
/*                                                                         */
/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */
/*                                                                         */
/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software Foundation, */
/* Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.         */
/*                                                                         */
/* *********************************************************************** */

#include "mex.h"
#include <matlabint_mesh.h>

/**@name del_mesh(i)
 * delete an existing mesh from memory. i should be a descriptor given
 * by new_mesh.
 */
//@{
//@}


void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
  if (nrhs != 1)
    mexErrMsgTxt("Wrong number of input arguments, should be 1.");
  if (nlhs != 0)
    mexErrMsgTxt("No output argument needed.");
  matlabint::id_type *p = (matlabint::id_type *)(mxGetData(prhs[0]));
  if (mxGetClassID(prhs[0]) != mxUINT32_CLASS 
      || (*p & 0xFF000000) != MATLABINT_MESH_MASK)
    mexErrMsgTxt("Input argument should be a descriptor returned by new_mesh.");
  int i = *p - MATLABINT_MESH_MASK;
  if (!matlabint::exists_mesh(i))
    mexErrMsgTxt("This mesh no longer exists.");

  matlabint::del_mesh(i);
}
