/* *********************************************************************** */
/*                                                                         */
/* Library : Matlab Command (matlabcom) version 1.0                        */
/* File    : curved_mesh.C : Build a mesh with an existing mesh and        */
/*                           a function.                                   */
/*                                                                         */
/* Date : October 12, 2001.                                                */
/* Author : Yves Renard, Yves.Renard@gmm.insa-tlse.fr                      */
/*                                                                         */
/* *********************************************************************** */
/*                                                                         */
/* Copyright (C) 2001  Yves Renard.                                        */
/*                                                                         */
/* This file is a part of GETFEM++                                         */
/*                                                                         */
/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; version 2 of the License.                 */
/*                                                                         */
/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */
/*                                                                         */
/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software Foundation, */
/* Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.         */
/*                                                                         */
/* *********************************************************************** */

#include "mex.h"
#include <matlabint_mesh.h>

/**@name curved_mesh(i, j, f), or  curved_mesh(i, j, inline('expr'))
 * Build a mesh j with a mesh i. the mesh j has one additional dimension
 * as i. The additional coordinate is obtained applying each point to the
 * matlab inline function f. Used to obtain meshes for shells.
 */
//@{
//@}

#define id_type matlabint::id_type

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
  mexint_test_narg(3, 3, 0, 0);
  
  id_type *p = (id_type *)(mxGetData(prhs[0]));
  if (mxGetClassID(prhs[0]) != mxUINT32_CLASS 
      || (*p & 0xFF000000) != MATLABINT_MESH_MASK)
    mexErrMsgTxt("First input argument should be a descriptor returned by new_mesh.");
  int i1 = *p - MATLABINT_MESH_MASK;
  if (!matlabint::exists_mesh(i1))
    mexErrMsgTxt("First mesh no longer exists.");
  getfem::getfem_mesh *pmesh1 = &(matlabint::mesh(i1));

  p = (id_type *)(mxGetData(prhs[1]));
  if (mxGetClassID(prhs[1]) != mxUINT32_CLASS 
      || (*p & 0xFF000000) != MATLABINT_MESH_MASK)
    mexErrMsgTxt("Second input argument should be a descriptor returned by new_mesh.");
  int i2 = *p - MATLABINT_MESH_MASK;
  if (!matlabint::exists_mesh(i2))
    mexErrMsgTxt("Second mesh no longer exists.");
  getfem::getfem_mesh *pmesh2 = &(matlabint::mesh(i2));

  double *q3 = (double *)(mxGetData(prhs[2]));
  if (mxGetClassID(prhs[2]) !=  mxDOUBLE_CLASS)
    mexErrMsgTxt("Third argument should be a Matlab double Vector.");
  int nc = mxGetN(prhs[2]) * mxGetM(prhs[2]);
  
  if (nc <= pmesh1->points().index().last())
    mexErrMsgTxt("Third argument has not the good size.");


  int dim = pmesh1->dim();
  bgeot::base_node pt(dim+1);
  pmesh2->clear();
  bgeot::size_type i, nbpt = pmesh1->points().index().last()+1;
  for (i = 0; i < nbpt; ++i)
  {
    std::copy(pmesh1->points()[i].begin(), pmesh1->points()[i].end(),
	      pt.begin());
    pt[dim] = q3[i];
    pmesh2->add_point(pt);
  }

  dal::bit_vector nn = pmesh1->convex_index();
  for (i << nn; i != bgeot::size_type(-1); i << nn)
  {
    pmesh2->add_convex(pmesh1->trans_of_convex(i),
		       pmesh1->ind_points_of_convex(i).begin());
  }
  
}
