function curved_mesh(mi, mj, F)
%       curved_mesh(i, j, F)   transform the mesh identified by i in a
%         mesh identified by j, with a supplementary dimension defined by 
%         the function F. Exemple, if i is a two-D mesh :
%         curved_mesh(i, j, inline('sin(x)*cos(y)'));
%
%
%       A. Huard, Y. Renard
%       $Date: 2002/04/26 14:59:11 $
M = points_of_mesh(mi);
n = size(M,1);
nbpt = size(M,2);
V = zeros(1, nbpt);

if (n == 1)
  for i = 1:nbpt
    V(i) = feval(F, M(1,i));
  end;
end;
if (n == 2)
  for i = 1:nbpt
    V(i) = feval(F, M(1,i), M(2, i));
  end;
end;
if (n == 3)
  for i = 1:nbpt
    V(i) = feval(F, M(1,i), M(2, i), M(3, i));
  end;
end;
if (n == 4)
  for i = 1:nbpt
    V(i) = feval(F, M(1,i), M(2, i), M(3, i), M(4, i));
  end;
end;
if (n == 5)
  disp('T''as pas froid aux yeux, toi dis donc!');
  for i = 1:nbpt
    V(i) = feval(F, M(1,i), M(2, i), M(3, i), M(4, i), M(5, i));
  end;
end;
if (n > 5)
  error('Sorry, for mesh of dimension higher than 5, you have to correct this function');
end;
curved_mesh_C(mi, mj, V);
