/* *********************************************************************** */
/*                                                                         */
/* Library : Matlab Command (matlabcom) version 1.0                        */
/* File    : convex_product_structure.C : gives the product of two convex  */
/*                                    structure.                           */
/*     									   */
/*                                                                         */
/* Date : September 28, 2001.                                              */
/* Author : Yves Renard, Yves.Renard@gmm.insa-tlse.fr                      */
/*                                                                         */
/* *********************************************************************** */
/*                                                                         */
/* Copyright (C) 2001  Yves Renard.                                        */
/*                                                                         */
/* This file is a part of GETFEM++                                         */
/*                                                                         */
/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; version 2 of the License.                 */
/*                                                                         */
/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */
/*                                                                         */
/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software Foundation, */
/* Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.         */
/*                                                                         */
/* *********************************************************************** */

#include "mex.h"
#include <matlabint_cvs.h>

#define id_type matlabint::id_type

/**@name k = convex_product_structure(i, j)
 * return an identifier on the structure which represents the direct product
 * of structures i and j.
 */
//@{
//@}

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
  if (nrhs != 2)
    mexErrMsgTxt("Wrong number of input arguments.");
  else if (nlhs != 1)
    mexErrMsgTxt("Wrong number of output argument.");
  id_type *p1 = (id_type *)(mxGetData(prhs[0]));
  if (mxGetClassID(prhs[0]) != mxUINT32_CLASS 
      || (*p1 & 0xFF000000) != MATLABINT_CVS_MASK)
    mexErrMsgTxt("First input argument should be a convex structure descriptor");
  id_type *p2 = (id_type *)(mxGetData(prhs[1]));
  if (mxGetClassID(prhs[1]) != mxUINT32_CLASS 
      || (*p2 & 0xFF000000) != MATLABINT_CVS_MASK)
    mexErrMsgTxt("second input argument should be a convex structure descriptor");

  id_type a = *p1 - MATLABINT_CVS_MASK;
  if (!matlabint::exists_cvs(a))
    mexErrMsgTxt("Convex structure corresponding to first argument does not exist.");
  id_type b = *p2 - MATLABINT_CVS_MASK;
  if (!matlabint::exists_cvs(b))
    mexErrMsgTxt("Convex structure corresponding to second argument does not exist.");
  
  int j = 1;
  plhs[0] = mxCreateNumericArray(1, &j, mxUINT32_CLASS, mxREAL);
  *((id_type *)(mxGetData(plhs[0]))) = matlabint::ind_cvs(bgeot::convex_product_structure(matlabint::addr_cvs(a), matlabint::addr_cvs(b))) + MATLABINT_CVS_MASK;
 
}
