/* *********************************************************************** */
/*                                                                         */
/* Library : Matlab Command (matlabcom)                                    */
/* File    : add_poly.C : add two polynomials.                             */
/*     									   */
/*                                                                         */
/* Date : October 10, 2001.                                                */
/* Author : Yves Renard, Yves.Renard@gmm.insa-tlse.fr                      */
/*                                                                         */
/* *********************************************************************** */
/*                                                                         */
/* Copyright (C) 2001  Yves Renard.                                        */
/*                                                                         */
/* This file is a part of GETFEM++                                         */
/*                                                                         */
/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; version 2 of the License.                 */
/*                                                                         */
/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */
/*                                                                         */
/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software Foundation, */
/* Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.         */
/*                                                                         */
/* *********************************************************************** */

#include "mex.h"
#include <matlabint_poly.h>

/**@name add_poly(i, j, k)
 * Add the polynomials of identifiers i and j, and put the result into
 * the polynomial of identifier k.
 */
//@{
//@}


void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
  if (nrhs != 3)
    mexErrMsgTxt("Wrong number of input arguments.");
  if (nlhs != 0)
    mexErrMsgTxt("No output argument needed.");
  matlabint::id_type *p = (matlabint::id_type *)(mxGetData(prhs[0]));
  if (mxGetClassID(prhs[0]) != mxUINT32_CLASS 
      || (*p & 0xFF000000) != MATLABINT_POLY_MASK)
   mexErrMsgTxt("Input argument should be a descriptor returned by new_poly.");
  int i = *p - MATLABINT_POLY_MASK;
  if (!matlabint::exists_poly(i))
    mexErrMsgTxt("This polynomial no longer exists.");

  p = (matlabint::id_type *)(mxGetData(prhs[1]));
  if (mxGetClassID(prhs[1]) != mxUINT32_CLASS 
      || (*p & 0xFF000000) != MATLABINT_POLY_MASK)
   mexErrMsgTxt("Input argument should be a descriptor returned by new_poly.");
  matlabint::id_type a = *p - MATLABINT_POLY_MASK;

    p = (matlabint::id_type *)(mxGetData(prhs[2]));
  if (mxGetClassID(prhs[2]) != mxUINT32_CLASS 
      || (*p & 0xFF000000) != MATLABINT_POLY_MASK)
   mexErrMsgTxt("Input argument should be a descriptor returned by new_poly.");
  matlabint::id_type b = *p - MATLABINT_POLY_MASK;

  if (matlabint::poly(i).dim() != matlabint::poly(a).dim())
    mexErrMsgTxt("The two polynomials have not the same number of variables.");

  matlabint::poly(b) = matlabint::poly(i) + matlabint::poly(a);
}
