% FUNCTION [x] = gf_mesh_set(mesh M, operation [, args])
% 
%     General function for modification of a mesh object.
% 
%   * [IDX]=gf_mesh_set(M,'pts', mat P)
%   Replace the coordinates of the mesh points with those given in P.
% 
%   * [IDX]=gf_mesh_set(M,'add_point', mat PT)
%   Insert new points in the mesh and return their #id.  PT should be an [n x m]
%   matrix , where n is the mesh dimension, and m is the number of points that
%   will be added to the mesh. On output, IDX contains the indices of these new
%   points.
%   
%    Remark: if some points are already part of the mesh (with a small tolerance
%   of approximately 1e-8), they won't be inserted again, and IDX will contain the
%   previously assigned indices of the points.
% 
%   * gf_mesh_set(M,'del_point', ivec PIDLST)
%   Removes one or more points from the mesh.  PIDLST should contain the  point
%   #id, such as the one returned by the 'add point' command.
% 
%   * IDX = gf_mesh_set(M,'add_convex', @geotrans CVTR, mat CVPTS)
%   Add a new convex into the mesh.  The convex structure (triangle, prism,...) is
%   given by CVTR (obtained with gf_geotrans('...')), and its points are given by
%   the columns of CVPTS. On return, IDX contains the convex number. CVPTS might
%   be a 3-dimensional array in order to insert more than one convex (or a two
%   dimensional array correctly shaped according to Fortran ordering).
% 
%   * gf_mesh_set(M,'del_convex', IDX)
%   Remove one or more convexes from the mesh.  IDX should contain the convexes
%   #ids, such as the ones returned bu gf_mesh_set(M,'add_convex').
% 
%   * gf_mesh_set(M,'del_convex_of_dim', ivec DIM)
%   Remove all convexes of dimension listed in DIM.  For example
%   gf_mesh_set(M,'del_convex_of_dim', [1,2]) remove all line segments, triangles
%   and quadrangles.
% 
%   * gf_mesh_set(M,'translate', vec V)
%   Translates each point of the mesh from V.
% 
%   * gf_mesh_set(M,'transform', mat T)
%   Applies the matrix T to each point of the mesh.  Note that T is not required
%   to be a NxN matrix (with N=gf_mesh_get(M,'dim')). Hence it is possible to
%   transform a 2D mesh into a 3D one (and reciprocally).
% 
%   * gf_mesh_set(M,'merge', @mesh M2)
%   Merge with the mesh M2.  Overlapping points won't be duplicated. If M2 is a
%   mesh_fem object, its linked mesh will be used.
% 
%   * gf_mesh_set(M,'optimize_structure')
%   Reset point and convex numbering.  After optimisation, the points (resp.
%   convexes) will be consecutively numbered from 1 to gf_mesh_get(M,'max_pid')
%   (resp. gf_mesh_get(M,'max_cvid')).
% 
%   * gf_mesh_set(M,'refine'[, ivec CVLST])
%   Use a Bank strategy for mesh refinement.   If CVLST is not given, the whole
%   mesh is refined. Note that the regions, and the finite element methods and
%   integration methods of the mesh_fem and mesh_im objects linked to this mesh
%   will be automagically refined.
% 
%   * gf_mesh_set(M,'region', int rnum, mat CVFLST) Assigns the
%   region number rnum to the convex faces stored in each column of the matrix
%   CVFLST. The first row of CVFLST contains a convex number, and the second row
%   contains a face number in the convex (or 0 for the whole convex -- regions are
%   usually used to store a list of convex faces, but you may also use them to
%   store a list of convexes).
% 
%   * gf_mesh_set(M,'delete_region', ivec RLST)
%   Remove the regions whose #ids are listed in RLST
% 
function [varargout]=gf_mesh_set(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('mesh_set',varargin{:});
  else
    gf_matlab('mesh_set',varargin{:});
    if (exist('ans','var') == 1), varargout{1}=ans; end;
  end;
