% FUNCTION MIM = gf_mesh_im(...)
% 
%   General constructor for @tmim object (integration methods on a mesh).
% 
%   * gf_mesh_im(mesh M [{integ IM|int IM_DEGREE}])
% 
%   Return a getfem handle to the newly created mesh_im object. For
%   convenience, optional arguments (IM or IM_DEGREE) can be provided,
%   in that case a call to gf_mesh_im_set(mim, 'integ', ..) is issued with these
%   arguments.
% 
%   * gf_mesh_im('load', fname[, mesh M])
%   Load a meshim from a file.   If the mesh M is not supplied (this kind of file
%   does not store the mesh), then it is read from the file and its descriptor is
%   returned as the second output argument.
% 
%   * gf_mesh_im('from_string', str[, mesh M])
%   Create a meshim object from its string description.  See also
%   gf_mesh_im_get(MIM,'char')
% 
%   * gf_mesh_im('clone', meshim MIM2)
%   Create a copy of a meshim.
% 
% 
%   $Id: gf_mesh_im.cc,v 1.4 2006/03/28 10:06:35 pommier Exp $
function [varargout]=gf_mesh_im(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('mesh_im',varargin{:});
  else
    gf_matlab('mesh_im',varargin{:});
    if (exist('ans','var') == 1), varargout{1}=ans; end;
  end;
