% FUNCTION MF = gf_mesh_fem(...)
% 
%   General constructor for mesh_fem objects (Finite Element basis
%   functions on a mesh).
% 
%   * gf_mesh_fem(mesh M [, int Qdim=1])
% 
%   Return a getfem handle to the newly created mesh_fem object.
% 
%   * gf_mesh_fem('load', fname[, mesh M])
%   Load a meshfem from a file.   If the mesh M is not supplied (this kind of file
%   does not store the mesh), then it is read from the file and its descriptor is
%   returned as the second output argument.
% 
%   * gf_mesh_fem('from_string', str[, mesh M])
%   Create a mesh_fem object from its string description.  See also
%   gf_mesh_fem_get(MF,'char')
% 
%   * gf_mesh_fem('clone', meshfem MF2)
%   Create a copy of a mesh_fem.
% 
% 
%   $Id: gf_mesh_fem.cc,v 1.4 2006/03/28 10:06:35 pommier Exp $
function [varargout]=gf_mesh_fem(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('mesh_fem',varargin{:});
  else
    gf_matlab('mesh_fem',varargin{:});
    if (exist('ans','var') == 1), varargout{1}=ans; end;
  end;
