// ====================================================================
// Copyright 2009
// Yann COLLETTE
// This file is released into the public domain
// ====================================================================

sci_getfem_path = get_absolute_file_path('builder_gateway_c.sce');
getfem_path = '/home/renard/temp/getfem-4.2';

// Functions extracted from getfem_interface.cc

Table = ['gf_workspace',           'sci_gf_scilab'; ...
         'gf_delete',              'sci_gf_scilab'; ...
         'gf_undelete',            'sci_gf_scilab'; ...
         'gf_eltm',                'sci_gf_scilab'; ...
         'gf_geotrans',            'sci_gf_scilab'; ...
         'gf_geotrans_get',        'sci_gf_scilab'; ...
         'gf_integ',               'sci_gf_scilab'; ...
         'gf_integ_get',           'sci_gf_scilab'; ...
         'gf_global_function',     'sci_gf_scilab'; ...
         'gf_global_function_get', 'sci_gf_scilab'; ...
         'gf_fem',                 'sci_gf_scilab'; ...
         'gf_fem_get',             'sci_gf_scilab'; ...
         'gf_cvstruct_get',        'sci_gf_scilab'; ...
         'gf_mesher_object',       'sci_gf_scilab'; ...
         'gf_mesher_object_get',   'sci_gf_scilab'; ...
         'gf_mesh',                'sci_gf_scilab'; ...
         'gf_mesh_get',            'sci_gf_scilab'; ...
         'gf_mesh_set',            'sci_gf_scilab'; ...
         'gf_mesh_fem',            'sci_gf_scilab'; ...
         'gf_mesh_fem_get',        'sci_gf_scilab'; ...
         'gf_mesh_fem_set',        'sci_gf_scilab'; ...
         'gf_mesh_im',             'sci_gf_scilab'; ...
         'gf_mesh_im_get',         'sci_gf_scilab'; ...
         'gf_mesh_im_set',         'sci_gf_scilab'; ...
         'gf_mdbrick',             'sci_gf_scilab'; ...
         'gf_mdbrick_get',         'sci_gf_scilab'; ...
         'gf_mdbrick_set',         'sci_gf_scilab'; ...
         'gf_mdstate',             'sci_gf_scilab'; ...
         'gf_mdstate_get',         'sci_gf_scilab'; ...
         'gf_mdstate_set',         'sci_gf_scilab'; ...
         'gf_model',               'sci_gf_scilab'; ...
         'gf_model_get',           'sci_gf_scilab'; ...
         'gf_model_set',           'sci_gf_scilab'; ...
         'gf_slice',               'sci_gf_scilab'; ...
         'gf_slice_get',           'sci_gf_scilab'; ...
         'gf_slice_set',           'sci_gf_scilab'; ...
         'gf_levelset',            'sci_gf_scilab'; ...
         'gf_levelset_get',        'sci_gf_scilab'; ...
         'gf_levelset_set',        'sci_gf_scilab'; ...
         'gf_mesh_levelset',       'sci_gf_scilab'; ...
         'gf_mesh_levelset_get',   'sci_gf_scilab'; ...
         'gf_mesh_levelset_set',   'sci_gf_scilab'; ...
         'gf_asm',                 'sci_gf_scilab'; ...
         'gf_compute',             'sci_gf_scilab'; ...
         'gf_precond',             'sci_gf_scilab'; ...
         'gf_precond_get',         'sci_gf_scilab'; ...
         'gf_spmat',               'sci_gf_scilab'; ...
         'gf_spmat_get',           'sci_gf_scilab'; ...
         'gf_spmat_set',           'sci_gf_scilab'; ...
         'gf_linsolve',            'sci_gf_scilab'; ...
         'gf_util',                'sci_gf_scilab'; ...
         'gf_exit',                'sci_gf_scilab'; ...
	 'gf_cont_struct_get',     'sci_gf_scilab'; ...
	 'gf_cont_struct',         'sci_gf_scilab'];

// Special functions added for matlab compatibility

Table = [Table; ...
	 'sp_luinc',   'sci_spluinc';   ...
	 'sp_lu',      'sci_splu';      ...
	 'sp_lusolve', 'sci_splusolve'; ...
	 'sp_cholinc', 'sci_spcholinc'; ...
	 'sp_chol',    'sci_spchol';    ...
	 'sp_chsolve', 'sci_spchsolve'; ...
	 'sp_cgne',    'sci_spcgne';    ...
	 'sp_cgs',     'sci_spcgs';     ...
	 'sp_gmres',   'sci_spgmres';   ...
	 'sp_mgcr',    'sci_spmgcr'];

Files = ['gfm_common.c','gfm_scilab.cpp','sci_spluinc.c','sci_spcholinc.c','sci_splu.c','sci_spchol.c', ...
         'sci_cgne.c','sci_cgs.c','sci_gmres.c','sci_mgcr.c','sci_spchsolve.c','sci_splusolve.c'];

Libraries = ['../../src/c/libsp_get'];

if getos()=='Windows' then
  getfem_path = pwd() + '\..\..\..\';
  
  cflags = ' /I' + sci_getfem_path + ' /I' + sci_getfem_path + '/../../src/c';
  cflags = cflags + ' /I' + getfem_path + '/interface/src/' + ' /I' + getfem_path + '/src/getfem';
  cflags = cflags + ' /I' + SCI + '/../../include/scilab'; // For the binary distribution
  cflags = cflags + ' /D__USE_DEPRECATED_STACK_FUNCTIONS__';

  ldflags = getfem_path + 'msvc2010\Release\libgetfemint.lib ';
  ldflags = ldflags + getfem_path + 'msvc2010\Release\libgetfem.lib ';
  ldflags = ldflags + getfem_path + 'msvc2010\Release\superlu.lib ';
  if (isfile(getfem_path + 'msvc2010\qhull-2011.1\lib\qhullstatic.lib')) then
    ldflags = ldflags + getfem_path + 'msvc2010\qhull-2011.1\lib\qhullstatic.lib ';
  end  
  if (isfile(getfem_path + 'msvc2010\muparser_v134\lib\muparser.lib')) then
    ldflags = ldflags + getfem_path + 'msvc2010\muparser_v134\lib\muparser.lib ';
  end  

  // Under windows, scilab ships only sparse_f.dll
  // We need first to recreate the lib part 

  // * Here are the mingw commands necessary to produce this lib library:
  //   echo EXPORT > sparse_f.def
  //   nm sparse_f.dll | grep 'T_' | sed 's/.* T _//' > sparse_f.def
  //   dll_tool --def sparse_f.def --dllname sparse_f.dll --outputfile sparse_f.lib
  // * Here are the visual commands necessary to produce this lib library:
  //   dumpbin /exports sparse_f.dll > sparse_f.def
  //   Edit sparse_f.def, add 'EXPORTS' on the first line and remove all the
  //   cryptic symbols except the symbol name.
  //   Now produce the lib file: lib /def:sparse_f.def /OUT:sparse_f.lib
    
  ldflags = ldflags + ' ' + SCI + '/bin/sparse_f.lib';

  // ldflags = ldflags + ' /NODEFAULTLIB:LIBCMT';
else
  cflags = ' -g -I' + sci_getfem_path + ' -I' + sci_getfem_path + ' -I' + sci_getfem_path + '/../../src/c';
  cflags = cflags + ' -I' + getfem_path + '/interface/src/' + ' -I' + getfem_path + '/src/getfem';
  cflags = cflags + ' -I' + SCI + '/../../include/scilab'; // For the binary distribution
  cflags = cflags + ' -D__USE_DEPRECATED_STACK_FUNCTIONS__';
  
  ldflags = sci_getfem_path + '/../../../.libs/libgetfemint.a ' + sci_getfem_path + '/../../../../../src/.libs/libgetfem.a';
end

if ~isempty('-lqhull') & getos()~='Windows' then
  ldflags = ldflags + ' -L/usr/lib -lqhull';
end

if ~isempty('-lmuparser') & getos()~='Windows' then
  ldflags = ldflags + ' -L/usr/lib -lmuparser';
end

tbx_build_gateway('scigetfem_c', Table, Files, sci_getfem_path, Libraries, ldflags, cflags);

clear tbx_build_gateway;
