% FUNCTION F=gf_precond_get(...)
% 
%   * gf_precond_get(P,'mult',vec V)
%   Apply the preconditioner to the supplied vector.
% 
%   * gf_precond_get(P,'tmult',vec V)
%   Apply the transposed preconditioner to the supplied vector.
% 
%   * gf_precond_get(P,'type')
%   Return a string describing the type of the preconditioner ('ilu', 'ildlt',..).
% 
%   * gf_precond_get(P,'size')
%   Return the dimensions of the preconditioner.
% 
%   * gf_precond_get(P,'is_complex')
%   Return 1 if the preconditioner stores complex values.
% 
%   * gf_precond_get(P,'info')
%   Return a short informative string about the preconditioner.
% 
function [varargout]=gf_precond_get(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('precond_get',varargin{:});
  else
    gf_matlab('precond_get',varargin{:});
    if (exist('ans','var') == 1), varargout{1}=ans; end;
  end;
