% FUNCTION M = gf_model('complex' | 'real')
%   General constructor for model objects. Return a getfem handle to the newly
%   created object.
% 
%   ``Model'' variables store the variables and the state data and the
%   description of a model. This includes the global tangent matrix, the
%   right hand side and the constraints. There are two kinds of models, the
%   ``real'' and the ``complex'' models.
% 
%   ``Model'' object is the evolution for Getfem++ 4.0 of the "MdState"
%   object.
% 
%   * MDS = gf_model('real')
%   Build a model for real unknowns.
% 
%   * MDS = gf_model('complex')
%   Build a model for complex unknowns.
% 
function [varargout]=gf_model(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('model',varargin{:});
  else
    gf_matlab('model',varargin{:});
    if (exist('ans','var') == 1), varargout{1}=ans; end;
  end;
