% FUNCTION I = gf_fem_get(F, ...)
%     General function for querying information about FEM objects.
%     
%   * gf_fem_get(fe,'nbdof'[, int CV])
%   Return the number of DOF for the FEM.  Some specific FEM (for example
%   'interpolated_fem') may require a convex number CV to give their result
%   (interpolated fems for example). In most of the case, you can omit this convex
%   number.
% 
%   * gf_fem_get(fe,'dim')
%   Return the dimension (dimension of the reference convex) of the FEM.
% 
%   * gf_fem_get(fe,'target_dim')
%   Return the dimension of the target space.  The target space dimension is
%   usually 1, except for vector FEMs (none of them has been implemented in
%   getfem++ for now)
% 
%   * gf_fem_get(fe,'pts'[, int CV])
%   Get the location of the degrees of freedom on the reference element.  Some
%   specific FEM may require a convex number CV to give their result (interpolated
%   fems for example). In most of the case, you can omit this convex number.
% 
%   * gf_fem_get(fe,'is_equivalent')
%   Return 0 if the FEM is not equivalent.  Equivalent FEM are evaluated on the
%   reference convex. This is the case of most classical FEMs.
% 
%   * gf_fem_get(fe,'is_lagrange')
%   Return 0 if the FEM is not of Lagrange type.
% 
%   * gf_fem_get(fe,'is_polynomial')
%   Return 0 if the basis functions are not polynomials.
% 
%   * gf_fem_get(fe,'estimated_degree')
%   Return an estimation of the polynomial degree of the FEM.
% 
%   * gf_fem_get(fe,'base_value',X)
%   Evaluate all base functions at the given point.
% 
%   * gf_fem_get(fe,'grad_base_value',X)
%   Evaluate the gradient of all base functions at the given point.
% 
%   * gf_fem_get(fe,'hess_base_value',X)
%   Evaluate the Hessian of all base functions at the given point.
% 
%   * gf_fem_get(fe,'poly_str')
%   Return (if possible) the polynomial expressions of the base functions in the
%   reference element.  This function will of course fail for non-polynomial FEMs.
% 
%   * gf_fem_get(fe,'char')
%   Ouput a (unique) string representation of the FEM.  This can be used to
%   perform comparisons between two different FEM objects.
% 
function [varargout]=gf_fem_get(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('fem_get',varargin{:});
  else
    gf_matlab('fem_get',varargin{:});
    if (exist('ans','var') == 1), varargout{1}=ans; end;
  end;
