% FUNCTION [x] = gf_mesh_im_set(meshim MIM, operation [, args])
% 
%   General function for modifying mesh_im objects
%   
%   * gf_mesh_im_set(MIM,'integ,' {integ IM|int IM_DEGREE} [, ivec CVIDX])
%   Set the integration method.  Assign an integration method to all convexes
%   whose #ids are listed in CVIDX. If CVIDX is not given, the integration is
%   assigned to all convexes. It is possible to assign a specific integration
%   method with an integration method handle IM obtained via
%   gf_integ('IM_SOMETHING'), or to let getfem choose a suitable integration
%   method with IM_DEGREE (choosen such that polynomials of degree <= IM_DEGREE
%   are exactly integrated. If IM_DEGREE=-1, then the dummy integration method
%   IM_NONE will be used.)
% 
% 
%   $Id: gf_mesh_im_set.cc 2722 2007-12-04 15:26:17Z renard $
function [varargout]=gf_mesh_im_set(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('mesh_im_set',varargin{:});
  else
    gf_matlab('mesh_im_set',varargin{:});
    if (exist('ans','var') == 1), varargout{1}=ans; end;
  end;
