% FUNCTION F=gf_precond(name_of_preconditioner, args)
% General constructor for getfem preconditioners.
% 
%   The preconditioners may store REAL or COMPLEX values. They accept getfem
% sparse matrices and Matlab sparse matrices.
% 
%   * gf_precond('identity')
%  Create a REAL identity precondioner.
% 
%   * gf_precond('cidentity')
%  Create a COMPLEX identity precondioner.
% 
%   * gf_precond('diagonal', @dcvec D)
%  Create a diagonal precondioner.
% 
%   * gf_precond('ildlt', @spmat M)
%  Create an ILDLT (Cholesky) preconditioner for the (symmetric) sparse matrix
% M.
%  This preconditioner has the same sparsity pattern than M (no fill-in).
% 
%   * gf_precond('ilu', @spmat M)
%  Create an ILU (Incomplete LU) preconditioner for the sparse matrix M.
%  This preconditioner has the same sparsity pattern than M (no fill-in).
% 
%   * gf_precond('ildltt', @spmat M [, int fillin [, scalar threshold]])
%  Create an ILDLT (Cholesky with filling) preconditioner for the (symmetric)
% sparse matrix M.
%   The preconditioner may add at most 'fillin' additional non-zero entries on
% each line. The default value for 'fillin' is 10, and the default threshold is
% 1e-7.
% 
%   * gf_precond('ilut', @spmat M [, int fillin [, scalar threshold]])
%  Create an ILUT (Incomplete LU with filling) preconditioner for the sparse
% matrix M.
%   The preconditioner may add at most 'fillin' additional non-zero entries on
% each line. The default value for 'fillin' is 10, and the default threshold is
% 1e-7.
% 
%   * gf_precond('superlu', @spmat M)
%  Uses SuperLU to build an exact factorization of the sparse matrix M.  This
% preconditioner is only available if the getfem-interface was built with
% SuperLU support. Note that LU factorization is likely to eat all your memory
% for 3D problems.
function [varargout]=gf_precond(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('precond',varargin{:});
  else
    gf_matlab('precond',varargin{:});
    if (exist('ans','var') == 1), varargout{1}=ans; end;
  end;
