% FUNCTION [x] = gf_mesh_im_get(meshim MIM, operation [, args])
% 
%   General function extracting information from mesh_im objects.
% 
%   * [INTEG, CV2I] = gf_mesh_im_get(MIM,'integ'[, CVLIST])
%   Return a list of integration methods used by the meshim.  INTEG is an array of
%   all @tinteg objects found in the convexes given in CVLST. If CV2F was supplied
%   as an output argument, it contains, for each convex listed in CVLST, the index
%   of its correspounding integration method in INTEG.  Convexes which are not
%   part of the mesh, or convexes which do not have any integration method have
%   their correspounding entry in CV2I set to -1.
% 
%   Example:
%      cvid=gf_mesh_get(mim,'cvid');
%      [f,c2f]=gf_mesh_im_get(mim, 'integ');
%      for i=1:size(f), sf{i}=gf_integ_get('char',f(i)); end;
%      for i=1:size(c2f),
%        disp(sprintf('the integration of convex %d is %s',...
%             cvid(i),sf{i}));
%      end;
%   * M = gf_mesh_im_get(MIM,'eltm,' @eltm MET, int CV [int F])
%   Return the elementary matrix (or tensor) integrated on the convex CV.
%   !!WARNING!! Be sure that the fem used for the construction of MET is
%   compatible with the fem assigned to element CV ! This is not checked by the
%   function ! If the argument F is given, then the elementary tensor is
%   integrated on the face F of CV instead of the whole convex.
% 
%   * gf_mesh_im_get(MIM,'save,' filename [,'with mesh'])
%   Saves a meshim in a text file (and optionaly its linked mesh object).
% 
%   * gf_mesh_im_get(MIM,'char'[,'with mesh'])
%   Output a string description of the mesh_im.   By default, it does not include
%   the description of the linked mesh object.
% 
%   * M=gf_mesh_im_get(MIM,'linked_mesh')
%   Returns a reference to the mesh object linked to MIM.
% 
%   * gf_mesh_im_get(MIM,'memsize')
%   Return the amount of memory (in bytes) used by the mesh_im object.  The result
%   does not take into account the linked mesh object.
% 
% 
%   $Id: gf_mesh_im_get.cc 2659 2007-07-25 11:03:54Z pommier $
function [varargout]=gf_mesh_im_get(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('mesh_im_get',varargin{:});
  else
    gf_matlab('mesh_im_get',varargin{:});
    if (exist('ans','var') == 1), varargout{1}=ans; end;
  end;
