% FUNCTION [...] = gf_mesh_get(mesh M, [operation [, args]])
% 
%   General mesh inquiry function. All these functions accept also a
%   mesh_fem argument instead of a mesh M (in that case, the mesh_fem
%   linked mesh will be used). Note that when your mesh is recognized as
%   a Matlab object , you can simply use "get(M, 'dim')" instead of
%   "gf_mesh_get(M, 'dim')".
% 
%   * gf_mesh_get(M,'dim')
%   Get the dimension of the mesh (2 for a 2D mesh, etc).
% 
%   * [mat PT]=gf_mesh_get(M,'pts'[, ivec PIDLST])
%   Return the list of point coordinates of the mesh.\\\\  Each column of the
%   returned matrix contains the coordinates of one point.  If the optional
%   argument PIDLST was given, only the points whose #id is listed in this vector
%   are returned. Otherwise, the returned matrix will have
%   gf_mesh_get(M,'max_pid') columns, which might be greater than
%   gf_mesh_get(M,'nbpts') (if some points of the mesh have been destroyed and no
%   call to gf_mesh_set(M,'optimize_structure') have been issued).  The columns
%   corresponding to deleted points will be filled with NaN. You can use
%   gf_mesh_get(M,'pid') to filter such invalid points.
% 
%   * gf_mesh_get(M,'nbpts')
%   Get the number of points of the mesh.
% 
%   * gf_mesh_get(M,'nbcvs')
%   Get the number of convexes of the mesh.
% 
%   * [ivec PID]=gf_mesh_get(M,'pid')
%   Return the list of points #id of the mesh.\\\\  Note that their numbering is
%   not supposed to be contiguous from 1 to gf_mesh_get(M,'nbpts'),  especially if
%   you destroyed some convexes. You can use gf_mesh_set(M,'optimize_structure')
%   to enforce a contiguous numbering. PID is a row vector.
% 
%   * [CVID] = gf_mesh_get(M,'cvid')
%   Return the list of all convex #id.\\\\  Note that their numbering is not
%   supposed to be contiguous from 1 to gf_mesh_get(M,'nbcvs'),  especially if
%   some points have been removed from the mesh. You can use
%   gf_mesh_set(M,'optimize_structure') to enforce a contiguous numbering. CVID is
%   a row vector.
% 
%   * gf_mesh_get(M,'max_pid')
%   Return the maximum #id of all points in the mesh (see 'max cvid').
% 
%   * gf_mesh_get(M,'max_cvid')
%   Return the maximum #id of all convexes in the mesh (see 'max pid').
% 
%   *  [PID,IDX]=gf_mesh_get(M,'pid_from_cvid'[,CVLST])
%   Return the points attached to each convex of the mesh.\\\\  If CVLST is
%   omitted, all the convexes will be considered (equivalent to CVLST =
%   @gf_mesh_get(M,'max_cvid')). IDX is a row vector, length(IDX) =
%   length(CVLIST)+1. PID is a row vector containing the concatenated list of
%   points of each convex in cvlst. Each entry of IDX is the position of the
%   corresponding convex point list in PID. Hence, for example, the list of points
%   of the second convex is PID(IDX(2):IDX(3)-1).\\  If CVLST contains convex #id
%   which do not exist in the mesh, their point list will be empty.
% 
%   * [ivec PIDLST]=gf_mesh_get(M,'pid_from_coords', mat PT)
%   Search point #id whose coordinates are listed in PT.\\\\  PT is an array
%   containing a list of point coordinates. On return, PIDLST is a row vector
%   containing points #id for each point found, and -1  -1 for those which where
%   not found in the mesh.
% 
%   * [ivec CVLST]=gf_mesh_get(M,'cvid_from_pid', ivec PIDLST)
%   Returns the convex #ids that share the point #ids given in PIDLST in a row
%   vector (possibly empty).
% 
%   * [ivec PIDLST]=gf_mesh_get(M,'orphaned_pid')
%   Returns the list of mesh nodes which are not linked to a convex.
% 
%   * [imat CVFLST]=gf_mesh_get(M,'faces_from_pid', ivec PIDLST)
%   Return the convex faces whose vertex #ids are in PIDLST.\\\\  For a convex
%   face to be returned, EACH of its points have to be listed in PIDLST. On
%   output, the first row of CVFLST contains the convex number, and the second row
%   contains the face number (local number in the convex).
% 
%   * [imat CVFLST]=gf_mesh_get(M,'faces_from_cvid', ivec CVLST,[ 'merge'])
%   Return a list of convexes faces from a list of convex #id.\\\\  CVFLST is a
%   two-rows matrix, the first row lists convex #ids, and the second lists face
%   numbers. The optional argument 'merge' merges faces shared by two convexes of
%   CVLST.
% 
%   * [CVFLST]=gf_mesh_get(M,'outer_faces'[, CVLST])
%   Return the faces which are not shared by two convexes.  If CVLST is not given,
%   it basically returns the mesh boundary. If CVLST is given, it returns the
%   boundary of the convex set whose #ids are listed in CVLST.
% 
%   * [E,C]=gf_mesh_get(M,'edges'[, CVLST][,'merge'])
%   [OBSOLETE FUNCTION! will be removed in a future release]\\\\  Return the list
%   of edges of mesh M for the convexes listed in the row vector CVLST. E is a 2 x
%   nb_edges matrix containing point indices. If CVLST is omitted, then the edges
%   of all convexes are returned. If CVLST has two rows then the first row is
%   supposed to contain convex numbers, and the second face numbers, of which the
%   edges will be returned.  If 'merge' is indicated, all common edges of convexes
%   are merged in a single edge.  If the optional output argument C is specified,
%   it will contain the convex number associated with each edge.
% 
%   * [E,C]=gf_mesh_get(M,'curved_edges', int N [, CVLST])
%   [OBSOLETE FUNCTION! will be removed in a future release]\\\\  More
%   sophisticated version of gf_mesh_get(M,'edges') designed for curved elements.
%   This one will return N (N>=2) points of the (curved) edges. With N==2, this is
%   equivalent to gf_mesh_get(M,'edges'). Since the points are no more always part
%   of the mesh, their coordinates are returned instead of points number, in the
%   array E which is a [ mesh_dim x 2 x nb_edges ] array.  If the optional output
%   argument C is specified, it will contain the convex number associated with
%   each edge.
% 
%   * [mat T]=gf_mesh_get(M,'triangulated_surface', int Nrefine [,CVLIST])
%   [OBSOLETE FUNCTION! will be removed in a future release]  Similar function to
%   gf_mesh_get(M,'curved_edges') : split (if necessary, i.e. if the geometric
%   transformation if non-linear) each face into sub-triangles and return their
%   coordinates in T (see also gf_compute(MF, U,'eval on P1 tri mesh'))
% 
%   * [mat N]=gf_mesh_get(M,'normal_of_face', int CV, int F[, int FPTNUM])
%   Evaluates the normal of convex CV, face F at the FPTNUMth point of the face.
%   If FPTNUM is not specified, then the normal is evaluated at each geometrical
%   node of the face.
% 
%   * [mat N] = gf_mesh_get(M,'normal_of_faces', imat CVFLST)
%   Evaluates (at face centers) the normals of convexes.  CVFLST is supposed to
%   contain convex numbers in its first row and convex face number in its second
%   row.
% 
%   * [Q]=gf_mesh_get(M,'quality'[,ivec CVLST])
%   Return an estimation of the quality of each convex (0 <= Q <= 1).
% 
%   * [CVS, ivec CV2STRUC]=gf_mesh_get(M,'cvstruct',[ivec CVLST])
%   Return an array of the convex structures.  If CVLST is not given, all convexes
%   are considered. Each convex structure is listed once in CVS, and CV2STRUC maps
%   the convexes indice in CVLST to the indice of its structure in CVS.
% 
%   * [GT,GT2STRUCT]=gf_mesh_get(M,'geotrans',[CVLST])
%   Returns an array of the geometric transformations.  See also
%   gf_mesh_get(M,'cvstruct').
% 
%   * BLST = gf_mesh_get(M,'regions')
%   Return the list of valid regions stored in the mesh.
% 
%   * CVFLST = gf_mesh_get(M,'region', int rnum)
%   Return the list of convexes/faces on the region 'rnum'.   On output, the first
%   row of I contains the convex numbers, and the second row contains the face
%   numbers (and 0 when the whole convex is in the region).
% 
%   * gf_mesh_get(M,'save', stringing FILENAME)
%   Save the mesh object to an ascii file.  This mesh can be restored with
%   gf_mesh('load', FILENAME).
% 
%   * S=gf_mesh_get(M,'char')
%   Output a string description of the mesh.
% 
%   * gf_mesh_get(M,'export_to_vtk', string filename, ... [,'ascii'][,'quality'])
%   Exports a mesh to a VTK file .   If 'quality' is specified, an estimation of
%   the quality of each convex will be written to the file.  See also
%   gf_mesh_fem_get(MF,'export_to_vtk') , gf_slice_get(SL,'export_to_vtk').
% 
%   * gf_mesh_get(M,'export_to_dx', string filename, ...
%   [,'ascii'][,'append'][,'as',string name,[,'serie',string
%   serie_name]][,'edges'])
%   Exports a mesh to an OpenDX file.   See also
%   gf_mesh_fem_get(MF,'export_to_dx') , gf_slice_get(SL,'export_to_dx').
% 
%   * gf_mesh_get(M,'memsize')
%   Return the amount of memory (in bytes) used by the mesh.
% 
% 
%   $Id: gf_mesh_get.cc 2659 2007-07-25 11:03:54Z pommier $
function [varargout]=gf_mesh_get(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('mesh_get',varargin{:});
  else
    gf_matlab('mesh_get',varargin{:});
    if (exist('ans','var') == 1), varargout{1}=ans; end;
  end;
