% FUNCTION [...] = gf_model_get(model M, [operation [, args]])
%
%   Get information from a model object.
%   
%
%   * b = gf_model_get(model M, 'is_complex')
%   Return 0 is the model is real, 1 if it is complex.
%
%   * T = gf_model_get(model M, 'tangent_matrix')
%   Return the tangent matrix stored in the model .
%
%   * gf_model_get(model M, 'rhs')
%   Return the right hand side of the tangent problem.
%
%   * z = gf_model_get(model M, 'memsize')
%   Return a rough approximation of the amount of memory (in bytes) used by
%   the model.
%
%   * gf_model_get(model M, 'listvar')
%   print to the output the list of variables and constants of the model.
%
%   * gf_model_get(model M, 'listbricks')
%   print to the output the list of bricks of the model.
%
%   * V = gf_model_get(model M, 'variable', string name[, int niter])
%   Gives the value of a variable or data.
%
%   * name = gf_model_get(model M, 'mult varname Dirichlet', int ind_brick)
%   Gives the name of the multiplier variable for a Dirichlet brick.
%   If the brick is not a Dirichlet condition with multiplier brick,
%   this function has an undefined behavior
%
%   * I = gf_model_get(model M, 'interval of variable', string varname)
%   Gives the interval of the variable `varname` in the linear system of
%   the model.
%
%   * V = gf_model_get(model M, 'from variables')
%   Return the vector of all the degrees of freedom of the model consisting
%   of the concatenation of the variables of the model (usefull
%   to solve your problem with you own solver).
%
%   * gf_model_get(model M, 'assembly'[, string option])
%   Assembly of the tangent system taking into account the terms
%   from all bricks. `option`, if specified, should be 'build_all',
%   'build_rhs', 'build_matrix' or 'pseudo_potential' (in that case,
%   the pseudo_potential is returned).
%   The default is to build the whole
%   tangent linear system (matrix and rhs). This function is usefull
%   to solve your problem with you own solver.
%
%   * gf_model_get(model M, 'solve'[, ...])
%   Run the standard getfem solver.
%   
%   Note that you should be able to use your own solver if you want
%   (it is possible to obtain the tangent matrix and its right hand
%   side with the gf_model_get(model M, 'tangent matrix') etc.).
%   
%   Various options can be specified:
%   
%   - 'noisy' or 'very_noisy'
%   the solver will display some information showing the progress
%   (residual values etc.).
%   - 'max_iter', int NIT
%   set the maximum iterations numbers.
%   - 'max_res', @float RES
%   set the target residual value.
%   - 'lsolver', string SOLVER_NAME
%   select explicitely the solver used for the linear systems (the
%   default value is 'auto', which lets getfem choose itself).
%   Possible values are 'superlu', 'mumps' (if supported),
%   'cg/ildlt', 'gmres/ilu' and 'gmres/ilut'.
%   - 'lsearch', string LINE_SEARCH_NAME
%   select explicitely the line search method used for the linear systems (the
%   default value is 'default').
%   Possible values are 'simplest', 'systematic'.
%   - 'with pseudo potential'
%   for nonlinear problems, the criterion of the line search will
%   be a pseudo potential instead of the residual. Still experimental since
%   not all bricks define a pseudo potential.
%
%   * V = gf_model_get(model M, 'compute isotropic linearized Von Mises or Tresca', string varname, string dataname_lambda, string dataname_mu, mesh_fem mf_vm[, string version])
%   Compute the Von-Mises stress or the Tresca stress of a field (only
%   valid for isotropic linearized elasticity in 3D). `version` should
%   be  'Von_Mises' or 'Tresca' ('Von_Mises' is the default).
%
%   * V = gf_model_get(model M, 'compute Von Mises or Tresca', string varname, string lawname, string dataname, mesh_fem mf_vm[, string version])
%   Compute on `mf_vm` the Von-Mises stress or the Tresca stress of a field
%   for nonlinear elasticity in 3D. `lawname` is the constitutive law which
%   could be 'SaintVenant Kirchhoff', 'Mooney Rivlin' or 'Ciarlet Geymonat'.
%   `dataname` is a vector of parameters for the constitutive law. Its length
%   depends on the law. It could be a short vector of constant values or a
%   vector field described on a finite element method for variable coefficients.
%   `version` should be  'Von_Mises' or 'Tresca' ('Von_Mises' is the default).
%
%   * V = gf_model_get(model M, 'compute plasticity Von Mises or Tresca', string datasigma, mesh_fem mf_vm[, string version])
%   Compute on `mf_vm` the Von-Mises or the Tresca stress of a field for plasticity and return it into the vector V.
%   `datasigma` is a vector which contains the stress constraints values supported by the mesh.
%   `version` should be  'Von_Mises' or 'Tresca' ('Von_Mises' is the default).
%
%   * gf_model_get(model M, 'compute plasticity constraints', mesh_im mim, string varname, string projname, string datalambda, string datamu, string datathreshold, string datasigma)
%   Compute and save the stress constraints sigma for other hypothetical iterations.
%   'mim' is the integration method to use for the computation.
%   'varname' is the main variable of the problem.
%   'projname' is the type of projection to use. For the moment it could only be 'Von Mises' or 'VM'.
%   'datalambda' and 'datamu' are the Lame coefficients of the material.
%   'datasigma' is a vector which will contains the new stress constraints values.
%
%   * V = gf_model_get(model M, 'compute plastic part', mesh_im mim, mesh_fem mf_pl, string varname, string projname, string datalambda, string datamu, string datathreshold, string datasigma)
%   Compute on `mf_pl` the plastic part and return it into the vector V.
%   `datasigma` is a vector which contains the stress constraints values supported by the mesh.
%
%   * M = gf_model_get(model M, 'matrix term', int ind_brick, int ind_term)
%   Gives the matrix term ind_term of the brick ind_brick if it exists
%   
%
%   * s = gf_model_get(model M, 'char')
%   Output a (unique) string representation of the model.
%   
%   This can be used to perform comparisons between two
%   different model objects.
%   This function is to be completed.
%   
%
%   * gf_model_get(model M, 'display')
%   displays a short summary for a model object.
%
%
function [varargout]=gf_model_get(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('model_get', varargin{:});
  else
    gf_matlab('model_get', varargin{:});
    if (exist('ans', 'var') == 1), varargout{1}=ans; end;
  end;
% autogenerated mfile;
