% FUNCTION [...] = gf_model([operation [, args]])
%
%   General constructor for model objects.
%
%   model variables store the variables and the state data and the
%   description of a model. This includes the global tangent matrix, the right
%   hand side and the constraints. There are two kinds of models, the `real`
%   and the `complex` models.
%   
%   model object is the evolution for getfem++ 4.0 of the mdstate object.
%   
%
%   * MD = gf_model('real')
%   Build a model for real unknowns.
%
%   * MD = gf_model('complex')
%   Build a model for complex unknowns.
%
%
function [varargout]=gf_model(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('model', varargin{:});
  else
    gf_matlab('model', varargin{:});
    if (exist('ans', 'var') == 1), varargout{1}=ans; end;
  end;
% autogenerated mfile;
