% FUNCTION [...] = gf_mesh_levelset([operation [, args]])
%
%   General constructor for mesh_levelset objects.
%
%   General constructor for mesh_levelset objects. The role of this object is
%   to provide a mesh cut by a certain number of level_set. This object is
%   used to build conformal integration method (object mim and enriched finite
%   element methods (Xfem)).
%   
%
%   * MLS = gf_mesh_levelset(mesh m)
%   Build a new mesh_levelset object from a mesh and returns its handle.
%
%
function [varargout]=gf_mesh_levelset(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('mesh_levelset', varargin{:});
  else
    gf_matlab('mesh_levelset', varargin{:});
    if (exist('ans', 'var') == 1), varargout{1}=ans; end;
  end;
% autogenerated mfile;
