% Integ = gf_integ(string method)
% 
%   Here is a list of some integration methods defined in getfem++
%  (see the description of finite element and integration methods
%  for a complete reference):
% 
%   * IM_EXACT_SIMPLEX(n)
%     Exact integration on simplices (works only with linear geometric
%     transformations and PK Fem's).
%  * IM_PRODUCT(A,B)
%     Product of two integration methods.
%  * IM_EXACT_PARALLELEPIPED(n)
%     Exact integration on parallelepipeds.
%  * IM_EXACT_PRISM(n)
%     Exact integration on prisms.
%  * IM_GAUSS1D(k)
%     Gauss method on the segment, order `k=1,3,...99`.
%  * IM_NC(n,k)
%     Newton-Cotes approximative integration on simplexes, order `k`.
%  * IM_NC_PARALLELEPIPED(n,k)
%     Product of Newton-Cotes integration on parallelepipeds.
%  * IM_NC_PRISM(n,k)
%     Product of Newton-Cotes integration on prisms.
%  * IM_GAUSS_PARALLELEPIPED(n,k)
%     Product of Gauss1D integration on parallelepipeds.
%  * IM_TRIANGLE(k)
%     Gauss methods on triangles `k=1,3,5,6,7,8,9,10,13,17,19`.
%  * IM_QUAD(k)
%     Gauss methods on quadrilaterons `k=2, 3, 5, .. 17`. Note that
% IM_GAUSS_PARALLELEPIPED should be prefered for QK Fem's.
%  * IM_TETRAHEDRON(k)
%     Gauss methods on tetrahedrons `k=1, 2, 3, 5, 6 or 8`.
%  * IM_SIMPLEX4D(3)
%     Gauss method on a 4-dimensional simplex.
%  * IM_STRUCTURED_COMPOSITE(im,k)
%     Composite method on a grid with `k` divisions.
%  * IM_HCT_COMPOSITE(im)
%     Composite integration suited to the HCT composite finite element.
% 
%   Example:
%  - gf_integ('IM_PRODUCT(IM_GAUSS1D(5),IM_GAUSS1D(5))')
%  is the same as:
%  - gf_integ('IM_GAUSS_PARALLELEPIPED(2,5)')
% 
%   Note that 'exact integration' should be avoided in general, since they
%  only apply to linear geometric transformations, are quite slow, and
%  subject to numerical stability problems for high degree Fem's.
function [varargout]=gf_integ(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('integ',varargin{:});
  else
    gf_matlab('integ',varargin{:});
    if (exist('ans','var') == 1), varargout{1}=ans; end;
  end;
