/**************************************************************************
 * BaseString - Functions for manipulation the string.
 * Version:     0.3.7 19/02/2006
 * File:        BaseString.c
 * Description: Tools of survival to the string. 
 * Error:       ID file 1, last number 09
 * Platform(s):	GNU/Linux, All
 * Author(s):	Della Bianca Giuseppe <bepi@adria.it><bepii@libero.it>
 *
 * Copyright (C) 2002-6 Della Bianca Giuseppe <bepi@adria.it><bepii@libero.it>
 * This file is part of GesConf.
 *
 * GesConf is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * GesConf is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GesConf; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 **************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include <limits.h>
#include "global.h"
#include "ErrLog.h"
#include "BaseString.h"

/**************************************************************************
 * Function: ltrim
 * Details:  Return one string without initial spaces. 
 * Returns: 
 **************************************************************************/
void ltrim (char *StrTrim){

  long LenStr, IniStrOut= 0, PosChar;
  char *StrTmp;

  LenStr= strlen (StrTrim);
// count the spaces at the beginning of string
  for (PosChar= 0; PosChar < LenStr; PosChar++){
    if (StrTrim[PosChar] != ' ')
      break; 
  }
// if they have been found spaces to eliminate 
  if (PosChar < LenStr)
    IniStrOut= PosChar;
// Avoids eventual problems of the copy of one string on same
  StrTmp= (char*) xmalloc (LenStr + 1);
  strcpy (StrTmp, &StrTrim[IniStrOut]);
  strcpy (StrTrim, StrTmp);
  free (StrTmp);

} // ltrim

/**************************************************************************
 * Function: rtrim
 * Details:  Return one string without final spaces 
 * Returns: 
 **************************************************************************/
void rtrim (char *StrTrim){

  long LenStr, LenStrOut, PosChar;
  char *StrTmp;

  LenStrOut= LenStr= strlen (StrTrim);
// count the spaces at the end of string
  for (PosChar= LenStr - 1; PosChar >= 0; PosChar--){
    if (StrTrim[PosChar] != ' ')
      break; 
  }
// if they have been found spaces to eliminate 
  if (PosChar >= 0)
    LenStrOut= PosChar + 1; 
// it avoids eventual problems of the copy of one string on same 
  StrTmp= (char*) xmalloc (LenStr + 1);
  strncpyV (StrTmp, StrTrim, LenStrOut, LenStr);
  strcpy (StrTrim, StrTmp);
  free (StrTmp);

} // rtrim

/**************************************************************************
 * Function: trim
 * Details:  Return one string without initial and final spaces.
 * Returns: 
 **************************************************************************/
void trim (char *StrTrim){

  long LenStr, IniStrOut= 0, LenStrOut, PosChar;
  char *StrTmp;

  LenStr= strlen (StrTrim);
// count the spaces at the beginning of string
  for (PosChar= 0; PosChar < LenStr; PosChar++){
    if (StrTrim[PosChar] != ' ')
      break; 
  }
// if they have been found spaces to eliminate 
  if (PosChar <= LenStr)
    IniStrOut= PosChar;

  LenStrOut= LenStr - IniStrOut;
// count the spaces at the end of string
  for (PosChar= LenStr - 1; PosChar >= IniStrOut; PosChar--){
    if (StrTrim[PosChar] != ' ')
      break; 
  }
// if they have been found spaces to eliminate 
  if (PosChar >= IniStrOut)
    LenStrOut= PosChar - IniStrOut + 1; 
// it avoids eventual problems of the copy of one string on same 
  StrTmp= (char*) xmalloc (LenStr + 1);
  strncpyV (StrTmp, &StrTrim[IniStrOut], LenStrOut, LenStr);
  strcpy (StrTrim, StrTmp);
  free (StrTmp);

} // trim

/**************************************************************************
 * Function: strcatV
 * Details:  Check lenght and append string.
 * Returns: 
 **************************************************************************/
int strcatV (char *StrOut, char *StrIn, long LenBuff){

  int result;
  char str[LENSTR + 1];

  if (result= strlen (StrOut) <= LenBuff){
    result= (strlen (StrOut) + strlen (StrIn)) <= LenBuff;
    strncatV (StrOut, StrIn, LenBuff, LenBuff);
    if (!result){
      sprintf (str, "%d", LenBuff);
      ElAddErr (106, "BS", _("With append %s the value %s is longer than %s"), StrIn, StrOut, str);
    }
  }
  else{
    sprintf (str, "%d", LenBuff);
    ElAddErr2 (105, "BS", _("The value %s is longer than %s"), StrOut, str);
  }

  return (result);
} // strcpyV

/**************************************************************************
 * Function: strcpyV
 * Details:  Check lenght and copy string. 
 * Returns: 
 **************************************************************************/
int strcpyV (char *StrOut, char *StrIn, long LenBuff){

  int result;
  char str[LENSTR + 1];

  result= strlen (StrIn) <= LenBuff;
  strncpyV (StrOut, StrIn, LenBuff, LenBuff);
  if (!result){
    sprintf (str, "%d", LenBuff);
    ElAddErr2 (104, "BS", _("The value %s is longer than %s"), StrIn, str);
  }

  return (result);
} // strcpyV

/**************************************************************************
 * Function: strncatV
 * Details:  Check lenght and append 'num' characters at to string,  
 *           terminates the string. 
 * Returns: 
 **************************************************************************/
int strncatV (char *StrOut, char *StrIn, long num, long LenBuff){

  int result= true;
  long LenSOut, LenCatBuff;
  char *pIniCat, str[LENSTR + 1];

  if (result= strlen (StrOut) <= LenBuff){
    LenSOut= strlen (StrOut);
    LenCatBuff= LenBuff - LenSOut;

    if (num > strlen (StrIn)){
      if (result= strlen (StrIn) <= LenCatBuff)
	num= strlen (StrIn);
    }
    else
      result= num <= LenCatBuff;

    if (!result)
      num= LenCatBuff;

    pIniCat= &StrOut[LenSOut];
    strncpy (pIniCat, StrIn, num);
    pIniCat[num]= '\0';

    if (!result){
      sprintf (str, "%d", LenBuff);
      ElAddErr (103, "BS", _("With append %s the value %s is longer than %s"), StrIn, StrOut, str);
    }
  } // if (result= strlen (StrOut) <= LenBuff)
  else{
    sprintf (str, "%d", LenBuff);
    ElAddErr2 (102, "BS", _("The value %s is longer than %s"), StrOut, str);
  }

  return (result);
} // strncatV

/**************************************************************************
 * Function: strncpyV
 * Details:  Check lenght and copy 'num' characters of string,  
 *           terminates the string. 
 * Returns: 
 **************************************************************************/
int strncpyV (char *StrOut, char *StrIn, long num, long LenBuff){

  int result= true;
  char str[LENSTR + 1];

  if (num > strlen (StrIn)){
    if (result= strlen (StrIn) <= LenBuff)
      num= strlen (StrIn);
  }
  else
    result= num <= LenBuff;

  if (!result)
    num= LenBuff;

  strncpy (StrOut, StrIn, num);
  StrOut[num]= '\0';

  if (!result){
    sprintf (str, "%d", LenBuff);
    ElAddErr2 (101, "BS", _("The value %s is longer than %s"), StrIn, str);
  }

  return (result);
} // strncpyV

/**************************************************************************
 * Function: strrepl
 * Details:  Check lenght and replaces the find string with another string.
 * Returns: 
 **************************************************************************/
int strrepl (char *StrTo, char *StrFor, char *StrRepl, long LenBuff){

  int result;
  long LenStrTo, LenStrFor, LenStrRepl, LenStrOut, IniSect, EndSect;
  char *StrTmp;
  char str[LENSTR + 1];

  LenStrOut= LenStrTo= strlen (StrTo);
  LenStrFor= strlen (StrFor);
  LenStrRepl= strlen (StrRepl);
// set the lenght of string with replaced char
  if (LenStrFor != LenStrRepl){
    LenStrOut= IniSect= 0;
    while (IniSect < LenStrTo){
      EndSect= strnspnN (StrTo, StrFor, IniSect);
      LenStrOut += (EndSect - IniSect);
      if (EndSect < LenStrTo)
	LenStrOut += LenStrRepl;
      IniSect= EndSect + LenStrFor;
    } // while (IniSect < LenStrTo)
  } // if (LenStrFor != LenStrRepl)

  if (!(result= LenStrOut <= LenBuff))
    LenStrOut= LenBuff;

  StrTmp= (char*) xmalloc (LenStrOut + 1);
  *StrTmp= '\0';
// replace char
  LenStrOut= IniSect= 0;
  while (IniSect < LenStrTo){
    EndSect= strnspnN (StrTo, StrFor, IniSect);
// check the lenght of string with replaced char
    LenStrOut += (EndSect - IniSect);
    if (EndSect < LenStrTo)
      LenStrOut += LenStrRepl;
// replace char
    if (LenStrOut <= LenBuff){
      strncat (StrTmp, &StrTo[IniSect], EndSect - IniSect);
      if (EndSect < LenStrTo)
	strcat (StrTmp, StrRepl);
      else
	strcat (StrTmp, "");
    }
    else
      break;
    IniSect= EndSect + LenStrFor;
  } // while (IniSect < LenStrTo)

  if (result)
    strcpy (StrTo, StrTmp);
  free (StrTmp);

  if (!result){
    sprintf (str, "%d", LenBuff);
    ElAddErr2 (107, "BS", _("The replaced value %s is longer than %s"), StrTo, str);
  }

  return (result);

} // strrepl

/**************************************************************************
 * Function: strtostr 
 * Details:  Insert one string in demanded position in another string.
 * Returns: 
 **************************************************************************/
void strtostr (char *SDest, char *SIns, long PosIns, long LenIns){

  long LenSDest, LenSIns, EndSIns, EndIns, LenFill;
  char *pIniIns;

// if the string to insert has valid values 
  if (PosIns > 0 && LenIns > 0){
    LenSDest= strlen (SDest);
    LenSIns= strlen (SIns);
    EndSIns= PosIns + LenSIns - 1;
    EndIns= PosIns + LenIns - 1;
// if the insertion is after the end of string of destination 
    LenFill= PosIns - LenSDest - 1;
    if (LenFill > 0){
      pIniIns= &SDest[LenSDest];
      sprintf (pIniIns, "%*s", LenFill, " ");
    }
    pIniIns= &SDest[PosIns - 1];
    strncpy (pIniIns, SIns, LenIns);
/* if the number of the inserted characters is inferior to the length 
   of the demanded insertion */ 
    LenFill= EndIns - EndSIns;
    if (LenFill > 0){
      pIniIns= &SDest[EndSIns];
      sprintf (pIniIns, "%*s", LenFill, " ");
    }
// if the insertion has arrived until after string of destination 
    if (EndIns > LenSDest)
      SDest[EndIns]= '\0';

  } // if (PosIns > 0 && LenIns > 0)
} // strtostr

/**************************************************************************
 * Function: strfromstr 
 * Details:  Return one string of the length demanded and from 
 *           position demanded from another string. 
 * Returns: 
 **************************************************************************/
void strfromstr (char *SDest, char *SIn, long PosIDest, long LenSDest){

  long LenSIn;

  *SDest= '\0';
// if the string to return has valid values 
  if (PosIDest > 0 && LenSDest > 0){
    LenSIn= strlen (SIn) + 1;
    if (PosIDest > LenSIn)
      PosIDest= LenSIn;
    strtostr (SDest, &SIn[PosIDest - 1], 1, LenSDest);
  }
} // strfromstr

/**************************************************************************
 * Function: strnspnN
 * Details:  Return the position of find string in another string 
 *           and search from the demanded position. 
 * Returns: 
 **************************************************************************/
long strnspnN (char *StrTo, char *StrFor, long IniFind){

  long LenStr, PosFind;
  char *pPosFind;

// set the initial position of search. 
  if (IniFind < 0)
    IniFind= 0;
  PosFind= LenStr= strlen (StrTo);
  if (IniFind < LenStr){
    pPosFind= strstr (&StrTo[IniFind], StrFor);
    if(pPosFind != NULL)
      PosFind= pPosFind - StrTo;
  }

  return (PosFind);
} // strnspnN

/**************************************************************************
 * Function: strtoken
 * Details:  Return the token contained in  row.
 * Returns:  *pRow == '\0' if not there are others token.
 **************************************************************************/
int strtoken (char **pRow, char *token, char *separ, long LenBuff){

  int result= true, CutDelim;
  long LenRow, LenToken, NumDelim, SepEndSect, DelEndSect, EndSect, IniNextSect;
  char *pWRow;

  *token= '\0';
  CutDelim= false;
  pWRow= *pRow;
  trim (pWRow);
  if (*pWRow != '\0'){
    LenRow= strlen (pWRow);
    DelEndSect= NumDelim= 0;
    EndSect= SepEndSect= strnspnN (pWRow, separ, 0);
// if string is delimited (ex. "ab")
    if (*pWRow == '\"'){
      EndSect= 0;
      NumDelim++;
// search the successive delimitator
      while (EndSect < LenRow){
	EndSect= strnspnN (pWRow, "\"", EndSect + 1);
	if (EndSect < LenRow){
	  if (!((*separ == ' ' && NumDelim < 2) || EndSect < SepEndSect))
	    break;
// if the delimitator is find
	  if (NumDelim != 2 || EndSect < SepEndSect){
// jump the doubles delimitator (ex. "a""b")
	    if (pWRow[EndSect + 1] == '\"' && (NumDelim & 1) != 0)
	      EndSect++;
	    else{
	      NumDelim++;
	      DelEndSect= EndSect;
	    }
	  }
	} // if (EndSect < LenRow)
      } // while (EndSect < LenRow)
      EndSect= DelEndSect;
      if (SepEndSect > EndSect)
	EndSect= SepEndSect;
// remove the delimitator
      if (NumDelim == 2){
	if (!strncpyV (token, pWRow, EndSect + 1, LenBuff))
	  result= false;
	trim (token);
	if (*token != '\0'){
	  LenToken= strlen (token) - 1;
	  if (token[LenToken] == '\"'){
	    CutDelim= true;
// set the found section whitout delimitator
	    if (!strncpyV (token, &pWRow[1], LenToken - 1, LenBuff))
	      result= false;
	  }
	} // if (*token != '\0')
      } // if (NumDelim == 2)
// disable replace double delimitator (ex. "a""b")
      if (false && CutDelim){
// replace double delimitator (ex. "a""b")
	if (!strrepl (token, "\"\"", "\"", LenBuff))
	  result= false;
      }
    } // if (*pWRow == '\"')
// set the found section
    if (!CutDelim){
      if (!strncpyV (token, pWRow, EndSect, LenBuff))
	result= false;
    }
    trim (token);
// removes from row the found section 
    IniNextSect= EndSect + 1;
    if (IniNextSect > LenRow)
      IniNextSect= LenRow;
    *pRow= &pWRow[IniNextSect];
  } // if (*pWRow != '\0')

  return (result);
} // strtoken

/**************************************************************************
 * Function: AddTxtWithSep
 * Details:  Add text at the end of the another text whith separator.
 * Returns: 
 **************************************************************************/
int AddTxtWithSep (char *TxtOut, char *TxtIn, char *TxtAdd, char *sep, long LenBuff){

  int result, LenText;
  char str[LENSTR + 1];

  LenText= strlen (TxtIn) + strlen (TxtAdd) + (*TxtIn != '\0' ? strlen (sep) : 0);
  if (result= LenText <= LenBuff)
    sprintf (TxtOut, "%s%s%s", TxtIn, *TxtIn != '\0' ? sep : "", TxtAdd);
  else{
    sprintf (str, "%d", LenBuff);
    ElAddErr (108, "FR", _("Adding %s to %s exceeds %s"), TxtAdd, TxtIn, str);
  }

  return (result);
} // AddTxtWithSep

/**************************************************************************
 * Function: CheckRow
 * Details:  Check the row and prepares it for next elaboration.
 * Returns: 
 **************************************************************************/
int CheckRow (char *RowIn){

  int result, LenRow;
  char str[LENSTR + 1];

  LenRow= strlen (RowIn);
  result= LenRow < MAXLENROWS;
// eliminates the eventual character of end row 
  if (RowIn[LenRow - 1] == '\n'){
    LenRow--;
    RowIn[LenRow]= '\0';
  }
  trim (RowIn);

  if (!result){
    sprintf (str, "%d", MAXLENROWS - 1);
    ElAddErr2 (109, "BR", _("The line %s is longer then %s"), RowIn, str);
  }

  return (result);
} // CheckRow

/**************************************************************************
 * Function: ParamsFromRow
 * Details:  Reads the row and return the several one token.
 * Returns:  pRow= pRow not still read, NumPar= number of the token inserted. 
 **************************************************************************/
int ParamsFromRow (char **pRow, char *par[], char *separ, int IniPar, int *NumPOut,
		   long LenBuff){

  int result= true, ParNum, NumPar;

  NumPar= *NumPOut;
  *NumPOut= 0;
  for (ParNum= 0; ParNum < NumPar; ParNum++){
    if (**pRow == '\0')
      *par[ParNum + IniPar]= '\0';
    else{
      if (!strtoken (pRow, par[ParNum + IniPar], separ, LenBuff))
	result= false;
      if (ParNum >= *NumPOut)
	*NumPOut= ParNum + 1; 
    }
  } // for (ParNum= 0; ParNum < NumPar; ParNum++)

  return (result);
} // ParamsFromRow

/**************************************************************************
 * Function: cutparstr
 * Details:  Sets one string in base to the format and the parameters, 
 *           the parameters are limited in their length. 
 * Returns: 
 **************************************************************************/
#define NUMCUTPAR 4

void cutparstr (char *str, int MaxLen, char *format, char *par1, char *par2, 
		char *par3){

  long DispLen, RecqLen, ParLen, LenCopy;
  long OverDispMin, OverDispMax, LenFlag;
  int ParNum;
  char *WPar[2][NUMCUTPAR], *ActPar;

  WPar[0][0]= format;
  WPar[0][1]= par1;
  WPar[0][2]= par2;
  WPar[0][3]= par3;

  DispLen= MaxLen;
  RecqLen= strlen (format) + strlen (par1) + strlen (par2) + strlen (par3);
  for (ParNum= 0; ParNum < NUMCUTPAR; ParNum++){
    ActPar= WPar[0][ParNum];
    WPar[1][ParNum]= (char*) xmalloc (MaxLen + 1);

    if (ActPar == NULL)
      *ActPar= '\0';
    LenCopy= ParLen= strlen (ActPar);
// reserve the space in the buffer for cut falg string or/and for next parameters
    if (RecqLen > DispLen){
      if ((RecqLen - ParLen) > 0){
	OverDispMin= (long)(MaxLen * ((ParNum == 0 ? 2.0 : 1.0) / NUMCUTPAR));
	OverDispMax= (long)(MaxLen * (1.0 - 1.1 / NUMCUTPAR));
	if (LenCopy > OverDispMin){
	  if (LenCopy > OverDispMax)
	    LenCopy= OverDispMax;
	  else
	    LenCopy= OverDispMin;
	}
      } // if ((RecqLen - ParLen) > 0)
      else
	LenCopy= DispLen;
    } // if (RecqLen > DispLen)
    if (LenCopy < 0 || LenCopy > DispLen)
      LenCopy= DispLen;
    DispLen -= LenCopy;
    RecqLen -= ParLen;

// reserve the space in the buffer for cut flag string
    if (LenCopy != ParLen){
      LenFlag= LenCopy >= 3 ? 3 : LenCopy;
      LenCopy -= LenFlag;
      if (LenCopy < 0)
	LenCopy= 0;
    }
    else
      LenFlag= 0;
    sprintf (WPar[1][ParNum], "%.*s%.*s", LenCopy, ActPar, LenFlag, "...");
  }
  sprintf (str, WPar[1][0], WPar[1][1], WPar[1][2], WPar[1][3]);

  for (ParNum= 0; ParNum < NUMCUTPAR; ParNum++)
    free (WPar[1][ParNum]);
} // cutparstr 

/**************************************************************************
 * Function: xmalloc
 * Details:  Allocate memory and verify.
 * Returns: 
 **************************************************************************/
void *xmalloc (size_t size){

  void *pMem;

  pMem= malloc (size);
  if (pMem == NULL){
    fprintf (stderr, _("FATAL ERROR: ALLOCATE MEMORY FAILED\n"));
    abort ();
  }

  return (pMem);
} // xmalloc
