// Copyright (C) 2005 Aldo Nicolas Bruno

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "common.h"
#include "xstring.h"
#include <stdio.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>

#include "xstringhash.h"
#include "xstringlist.h"
#include "xstringvector.h"
#include "utils.h"


xstring inputfile(const xstring & file)
{
  xstring a;
  int f=open( file.text() , O_RDONLY|O_LARGEFILE);
  if (f<0)
    { 
#ifdef DEBUG
      perror("Error in open() call");
#endif
      return "";
    }
  xstring buff(2050);
  buff.setbinary(true);
  char *b=buff.getbuffer();

  while (1)
    {
      ssize_t r=read(f,b,2048); // XXX
      if(r==0) break;
      if (r<0)
	{
#ifdef DEBUG
	  perror("error in read() call");
#endif
	  close (f);
	  return "";
	}

      buff.setlength(r);
      a+=buff;
    }
  return a;
}

xstringhash readoptions(const xstringvector & files)
{
  xstringhash hash;

  int i =0, n=files.n();
  for (;i<n; ++i)
    {
      errno=0;
      xstring f=inputfile(files[i]);
      if (errno)
	continue;
      std::cout << "Using config file "<< files[i] << std::endl;

      xstringvector seps;
      seps.append("\r\n");
      seps.append("\n");
      seps.append("\r");

      xstringvector v=f.splitss(seps);

      int j=0,m=v.n();
      for (;j<m; ++j)
	{
	  v[j]=v[j].splitc('#',1)[0];
	  v[j].trim();
	  hash.additemfromstring(v[j],'=');
	}
      break;
    }
  return hash;
}
