// -*- Mode: C++ -*-
// Copyright (C) 2005-2006 Aldo Nicolas Bruno

/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "config.h"
#include "pythonmodules.h"

#include "gepal.h"



PythonModules::PythonModules(HTTPServer* server)
  :Object("PythonModules"),HTTPResource(server)
{
  status=0;
  // initialize the python interpreter
  Py_Initialize();

  PyObject * name = PyString_FromString("gepal-backend");
  module= PyImport_Import(name);
  Py_DECREF(name);

  if (!module) 
  
    {
      std::cerr << "Fatal: error loading module gepal-backend: "; 
      PyErr_Print();

      status=-1;
      return;
    }

  PyObject *dict, *func, *args, *value,*backend_class;
 
  dict = PyModule_GetDict(module);// dict borrowed
  backend_class = PyDict_GetItemString(dict,"backend"); // func borrowed
  
  if (backend_class)
    {
      args = PyTuple_New(1);
      value = PyDict_New();
      
      if (!value) 
	{
	  Py_DECREF(args);
	  //Py_DECREF(module);
	  
	  MYTRACE("PythonModules(): Cannot convert argument\n");
	  PyErr_Print();
	  
	  //	  r=GEPAL_ERROR(ifce,"Error: cannot convert argument");
	  // TODO Bail out!!!
	}

      
      xstring dbconnectstring;
      //      if(dbhost.notempty())
	dbconnectstring+= "host="+options.getvalue("dbhost") + " ";
	//      if(database.notempty())
	dbconnectstring+= "dbname="+options.getvalue("database")+" ";
	//      if(dbuser.notempty())
        dbconnectstring+= "user="+ options.getvalue("dbuser") + " ";
	//      if(dbpassword.notempty())
	dbconnectstring+= "password="+ options.getvalue("dbpassword");

      
      //connect string
      PyObject * dbcs = PyString_FromStringAndSize(dbconnectstring.text(),dbconnectstring.length());
      PyDict_SetItemString(value,"dbconnectstring",dbcs);

      //package for modules
      dbcs = PyString_FromString(options.getvalue("modules_package").text());
      PyDict_SetItemString(value,"modules_package",dbcs);

      //document root
      dbcs = PyString_FromString(server->getdocroot().text());
      PyDict_SetItemString(value,"docroot",dbcs);

      //server version
      dbcs = PyString_FromString(PACKAGE_STRING);
      PyDict_SetItemString(value,"version",dbcs);


      if (createdb)
	{
	  dbcs= PyString_FromString("");// value reserved for future use
	  PyDict_SetItemString(value,"createdb",dbcs);
	}

      //value stolen 
      PyTuple_SetItem(args, 0, value);
      
      //value stolen
      backend=PyInstance_New(backend_class,args,NULL);
      //      value = PyObject_CallMethod(func,args);

      if (backend != NULL) 
	{
	  /*  char * s = PyString_AsString(value);
	  r.frombinary(s,PyString_Size(value));
	  printf("Result of call: %s\n", s); */
	  //Py_DECREF(value); // we don't care of the result (by now)
	}
      else 
	{
	  PyErr_Print();
	  fprintf(stderr,"backend.__init__() Call failed\n");
	  //	  r="Error: call to gepal-backend.init() failed!";
	  status=-1;
	 
	}
      Py_DECREF(backend_class);
    }
  else
    {
      cerr << "Error loading class backend" << endl;
      PyErr_Print();
      status=-1;
    }
  if (createdb)
    {
      exit(0);
    }
}

PythonModules::~PythonModules()
{
  // free python resources
  if (module)Py_DECREF(module);
  if (backend)Py_DECREF(backend);
  Py_Finalize();
}

int PythonModules::checkres(const xstring& abspath) const
{
  if(abspath=="/xml" || abspath=="/xhtml") return 1;
  return 0;
}


#define GEPAL_ERROR_XML(x) "<?xml version=\"1.0\"?><gepal><error>" x "</error></gepal>"

#define GEPAL_ERROR_HTML(x) "<html><body>" x "</body></html>"

#define GEPAL_ERROR(ifce,x)(ifce==GEPAL_REQUEST_XML?GEPAL_ERROR_XML(x):GEPAL_ERROR_HTML(x))

enum 
  {
    GEPAL_REQUEST_XML=1,
    GEPAL_REQUEST_HTML=2
  };

int PythonModules::response()
{

  int ifce=GEPAL_REQUEST_HTML;
  if (req->getres()=="/xml")
    ifce=GEPAL_REQUEST_XML;

  MYTRACE("PythonModules::response()");
  
  xstring data;
  if (ifce==GEPAL_REQUEST_XML)
    data=req->getpostdata();
  
  //xstringvector v = data.splitc('\n',2);
  
  PyObject *dict, *func, *args, *value,*value2;

  xstring r="";

  if (backend != NULL) 
    {
      // dict = PyModule_GetDict(module);// dict borrowed

      char * str="";
      if (ifce==GEPAL_REQUEST_XML)
	//func = PyDict_GetItemString(dict,"processxml"); // func borrowed
	str="processxml";
      else
	//func = PyDict_GetItemString(dict,"processhtml");
	str="processhtml";
      func= PyString_FromStringAndSize(str,strlen(str));

      if (true)
	{
	  
	  //args = PyTuple_New(1);
	  value = PyString_FromStringAndSize(data.text(),data.length());
	  if (!value) 
	    {
	      //Py_DECREF(args);
	      //Py_DECREF(module);
	      MYTRACE("PythonModules::response(): Cannot convert argument\n");
	      r=GEPAL_ERROR(ifce,"Error: cannot convert argument");
	      goto finish;
	    }
	  //value stolen 
	  //PyTuple_SetItem(args, 0, value);
	  

	  value2 = PyObject_CallMethodObjArgs(backend,func,value,NULL);
	  Py_DECREF(func);
	  Py_DECREF(value);
	  value=NULL;
	  func=NULL;
	  if (value2 != NULL) 
	    {
	      char * s = PyString_AsString(value2);
	      r.frombinary(s,PyString_Size(value2));
#ifdef DEBUG
	      printf("Result of call: %s\n", s);
#endif
	      Py_DECREF(value2);
	      value2=NULL;
	    }
	  else 
	    {
	      PyErr_Print();
	      fprintf(stderr,"Call failed\n");
	      r=GEPAL_ERROR(ifce,"Error: call to gepal-backend.process() failed!");
	      goto finish;
	    }
	  // dict and func are borrowed and must not be Py_DECREF-ed
	}
      else 
	{
	  if (PyErr_Occurred())
	    PyErr_Print();
	  fprintf(stderr, "Cannot find function \"%s\"\n", "process");
	}
    }
  else 
    {
      PyErr_Print();
      fprintf(stderr, "Failed to load \"%s\"\n", "gepal-backend");
      r=GEPAL_ERROR(ifce,"Error: Failed to load gepal-backend module");
    } 
 

 finish:
  if (r.isempty() && ifce != GEPAL_REQUEST_HTML)
    {
      r=GEPAL_ERROR(ifce,"Error executing request (internal error), empty response");
    }

  resp->sendstatus(200);
  resp->sendresponse(req,"",r);
#ifdef DEBUG
  std::cout << "response : " << r << endl;
#endif 

  return 0;
}
