

#include <string.h>
#include <unistd.h>

#include <xstring.h>

#include "config.h"
#include "gepal.h"
#include "params.h"

int parse_options(int argc, char*argv[])
{
  program_name=*argv;


  if(argc<2) return 0;

  char *p;

#define OK_2PARAMS { ++p; ++i; continue; }
#define OK_1PARAM { continue; }
#define EQUALS(x,y) (strcmp((x),(y)) == 0)

  for (int i=1; i < argc; ++i)
    {
      const char *p=argv[i];
      if(argc > i+1)
	{
	  const char* q=argv[i+1];
		  
	  if( EQUALS(p, "--port") || EQUALS(p,"-p" ) )
	    {
	      options.additem("port",q);
	      OK_2PARAMS;
	    }
	  else if ( EQUALS(p, "--host") || EQUALS(p,"-a") ) 
	    {
	      options.additem("host",q);
	      OK_2PARAMS;
	    }
	  else if ( EQUALS(p, "--docroot") || EQUALS(p,"-d") ) 
	    {
	      options.additem("docroot",q);
	      OK_2PARAMS;
	    }
	  else if ( EQUALS(p,"--database") || EQUALS(p,"-n") )
	    {
	      options.additem("database",q);
	      OK_2PARAMS;
	    }
	  else if ( EQUALS(p,"--dbuser") || EQUALS(p,"-u") )
	    {
	      options.additem("dbuser",q);
	      OK_2PARAMS;
	    }
	  else if ( EQUALS(p,"--dbpassword") || EQUALS(p,"-k"))
	    {
	      options.additem("dbpassword",q);
	      OK_2PARAMS;
	    }
	  else if ( EQUALS(p,"--dbhost") || EQUALS(p,"-H"))
	    {
	      options.additem("dbhost",q);
	      OK_2PARAMS;
	    }
	  else if ( EQUALS(p,"--connections") || EQUALS(p,"-N"))
	    {
	      options.additem("connections",q);
	      OK_2PARAMS;
	    }

	  else if ( EQUALS(p,"--modules-package") || EQUALS(p,"-M"))
	    {
	      options.additem("modules_package",q);
	      OK_2PARAMS;
	    }

	  else if ( EQUALS(p,"--config-file") || EQUALS(p,"-C"))
	    {
	      options.additem("configfile",q);
	      OK_2PARAMS;
	    }
	}
      if (EQUALS(p,"--verbose" ) || EQUALS (p,"-V" )  ) 
	{
	  verbose++;
	  OK_1PARAM;
	}
      else if (EQUALS(p,"--createdb"))
	{
	  createdb=1;
	  OK_1PARAM;
	}
      else if(EQUALS(p,"--daemon" ) || EQUALS (p,"-d" )  ) 
	{
	  rundaemon=1;
	  OK_1PARAM;
	}
      else if ( EQUALS(p,"--help") || EQUALS (p,"-h") )
	{
	  
	}
      else
	std::cout << "Syntax Error: Unknown parameter `" << p << "'" << std::endl; 
      // ELSE:
      std::cout << "GEPAL " << VERSION << std::endl 
		<< "Usage: gepal [options]" << std::endl
		<< std::endl
		<< "--help\t -h\tShow this help\n" 
		<< "--version\t-v\tShow Version Information\n"
		<< "--verbose\t-V\tTurn on verbose mode - Repeat for more verbose output\n"
		<< "--host <ip>|<hostname>\t-a\t Specify the iface to listen into: default is \"\" (INADDR_ANY)\n"
		<< "--port <port>\t-p\tSpecify port to listen into\n"
		<< "--docroot <dir>\t-p\tSpecify the document root for HTTP\n"	
		<< "--database <name>\t-n\tSpecify database name\n"
		<< "--dbuser <name>\t-u\tSpecify database user name\n"
		<< "--dbpassword <key>\t-k\tSpecify database password\n"
		<< "--connections <n>\t-N\tSpecify number of threads\n" 
		<< "--modules-package <m>\t-M\tSpecify the package name for python modules\n" 
		<< "--config-file <f>\t-M\tSpecify the full path to the config file ["CONFPREFIX"/gepal/gepal.conf]\n" 

		<< "--daemon\t-d\tRun as daemon\n"
		<< "--createdb\t\tCreate tables for all modules\n"
	;
      return 1;
    }
  return 0;
#undef OK_2PARAMS
#undef OK_1PARAM
#undef EQUALS
}
