// -*- Mode: C++ -*-
// Copyright (C) 2005-2006 Aldo Nicolas Bruno

/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include <signal.h>

#include <sys/types.h>
#include <sys/stat.h>

#include <fcntl.h>

#include <unistd.h>
#include <stdio.h>
#include <libgen.h>
#include <stdlib.h>
#include <pwd.h>

#include <nhttpd.h>

//#include "dbmarticoli.h"
//#include "dbserver.h"

#include "utils.h"
//#include "postgresdb.h"

#include "pythonmodules.h"


#include "gepal.h"

#include "params.h"

//#include <libguile.h>

xstringhash options;

int verbose=0;
bool createdb=false;
int rundaemon=0;
char * program_name="";

void interrupt_sigsegv(int signal)
{
  fprintf(stdout,"gepal: Segmentation fault!!!! PID: %d\n",getpid() );
  abort();
}

// do not use this!
#if 0

static int loadmodules(DBServer* x)
{
  cout << "loading modules...\n";    
  
  xstring ld_lib=getenv("GEPAL_MODULES_DIR");

  if (ld_lib.isempty())
    {
      xstring buff=program_name;
      ld_lib=dirname(buff.getbuffer());
    }

  cout << "Modules should be in: " << ld_lib << endl;

  xstringvector a=ld_lib.splitc(':');  

  int loadedn=0;

  int l=a.n();
  for (int i=0; i< l ; ++i)
    {
      xstring contents = inputfile(a[i]+"/load.list");
      //   cout << a[i] + "/load.list:\n" << contents << endl;
      if (contents.isempty())
	continue;

      xstringvector v(3);
      v.append("\r\n"); v.append("\r"); v.append("\n");
      xstringvector mods = contents.splitss(v);
      
      long nm=mods.n();
      for (int j=0; j<nm; ++j)
	{
	 
	  int pos = mods[j].search('#'); // remove comments
	  if (pos>=0) mods[j]=mods[j].left(pos);

	  mods[j].trim(); // remove white spaces

	  if(mods[j].isempty()) continue;

	  cout << "Trying to load Module " << mods[j] <<endl;
	  int r = x->addmodule(a[i]+"/"+mods[j]);
	  
	  if(r>=0) 
	    cout << "Loaded Module " << mods[j] << endl;
	  else
	    cout << "Failed loading Module " << mods[j] << endl;
	}
    }
  return 0;
}

#endif


static void parse_config_helper (const xstringhash& hash, const xstring& name,const xstring& defaul)
{
  if (!options.hasitem(name))
    {
      if ( hash.hasitem(name) )
	options.additem(name,hash.getvalue(name));
      else
	options.additem(name,defaul);
    }
}

static int parse_config()
{
  xstringvector v;
  //  v.append("~/gepal/gepal.conf");

  if (options.hasitem("configfile"))
    v.append(options.getvalue("configfile"));
  // FIXME by now we put only a config path
  else
     v.append(CONFPREFIX"/gepal/gepal.conf");

  xstringhash dict=readoptions(v);
  
  parse_config_helper(dict,"host","localhost");
  parse_config_helper(dict,"port","8023");
  parse_config_helper(dict,"docroot",PREFIX"/share/gepal");
  parse_config_helper(dict,"database","gepal");
  parse_config_helper(dict,"dbuser","gepal");
  parse_config_helper(dict,"dbpassword","");
  parse_config_helper(dict,"dbhost","localhost");
  parse_config_helper(dict,"connections","10");
  parse_config_helper(dict,"modules_package","modules");
  parse_config_helper(dict,"user","gepal");
}

class GEPALServer : public virtual HTTPServer
{  
public:
  GEPALServer();
  
  virtual int oninit();
};

GEPALServer::GEPALServer()
  : HTTPServer()
{
  // ecco un po di hacking per creare il db:
  if (createdb)
    {
      PythonModules *w=new PythonModules(this);
      // never reached
    }
}

int GEPALServer::oninit()
{
  // TODO load here the worker-dependent resources!!
 
  PythonModules * w = new PythonModules(this);
  
  addres("",w);
  }

void deletepidfile()
{
  unlink (GEPAL_PID_FILE);
}

int createpidfile()
{
  // check that the server is not running
  struct stat st;
  int k=stat(GEPAL_PID_FILE,&st);
  
  if (k<0 && errno==EACCES)
    {
      perror("Warning: could not access to pid file " GEPAL_PID_FILE);
      return -1;
    }
  // if (k>=0 || (k<0 && errno!=ENOENT) )
//     {
//       exit(-1);
//     }


  // write the pid
  int f=open(GEPAL_PID_FILE,O_CREAT|O_RDWR|O_EXCL,0664);
  if (f<0)
    {
      if (errno==EEXIST)
	{
	  cerr << "PID File "  GEPAL_PID_FILE " already exists, "
	    "ensure that gepal server is not already running. " 
	    "Otherwise delete the file by hand." << endl;
	  exit(-1);
	}
      perror("Warning: Error while opening pid file");
      return -1;
    }
  xstring a=xstring::fromlong( (long)getpid() ) + "\n";

  if (write(f,a.text(),a.length()) <0)
    perror("Warning: Error while writing to pid file");
  close(f);

  atexit(deletepidfile);

  return 0;
}


int main(int argc, char*argv[])
{
  signal(SIGSEGV,interrupt_sigsegv);

//   if (getuid() == 0) 
//     {
//       struct passwd *pw = getpwnam(options.getvalue("user").text());
//       if (! pw)
// 	{
// 	  cout << "Error: could not get user id for " << options.getvalue("user") << endl;
// 	  exit(1);
// 	}
//       int r =  setreuid(pw->pw_uid,pw->pw_uid);

//       if (r<0)
// 	{
// 	  perror( "Error: could not set uid");
// 	  exit (1);
// 	}
//     }
//   else
//     {
//       cout << "Warning: running gepal as unprivileged user, may not work as expected\n";
//     }
  
  createpidfile();  
  cout << "Starting up...\n";

  if( parse_options(argc,argv) )
    exit(1);

  parse_config();
  //  DB* db=new PostgresDB(database,dbuser,dbpassword);

  GEPALServer s;

  if(s.bind(options.getvalue("host"),
	    options.getvalue("port").getint() 
	    )
     < 0
     ) exit(-1);

  if(s.listen()<0) 
    exit(-1);
  
  // Deprecated interfaces (at least by now)
  //DBServer *x=new DBServer(&s,db);
  //  loadmodules(x);
  //  s.addres("/dbinterface",x);
  s.setdocroot(options.getvalue("docroot"));
    
  if (rundaemon)
    {
      int x=daemon(1,1);
      if (x<0)
	perror("gepal: warning: unable to run as daemon");
    }
  
  s.handle(options.getvalue("connections").getint());


  return 0;
}
