#! /usr/bin/python

# Copyright (C) 2005 Cristian Greggio
# Copyright (C) 2006 Aldo Nicolas Bruno

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import os
from module import *


class handler(module):
    def __init__(self,name,be):
        module.__init__(self,name,"Articoli",be) # serve a identificare il nome mod

        self.gen()
        
        #self.addhandler("add",self.addmod,menu="Aggiungi")
        #self.addhandler("add-db",self.add_db)

        self.addhandler("del",self.del_db)

#        self.addhandler("prova",self.prova)
        
#    def prova(self,d,e):
#        a=e.attrib
#        print a
    
        
    def field_gen(self,x):
        ##name,title,type,defvalue,maxlen,optional,password,help,multiline,tooltip,ref,refname,refattrib
    ##attenzione il primo elemento verra usato come riferimento fisso x la modifica
        x.addfield("codice","Codice","str","",15,
                   False,None,"",False,"Esempio: ART10023")
        x.addfield("descrizione","Descrizione","str","",50,
                   False,None,"",False,"Descrizione breve")
        x.addfield("um","UM","str","PZ",4,
                   False,None,"",False,"Unita\' di misura: ad esempio PZ o KG",
                   "articoli-um/list","codice"),
        x.addfield("tipo","Tipo articolo","str","",10,
                   False,None,"",False,"",
                   "articoli-tipi/list","codice")
        x.addfield("prezzo_std","Prezzo standard","float","0.0",3,
                   False,None,"",False,
                   "Prezzo standard (di riferimento)")
        
    def field_gen_ex(self,x):
        x.addfield("testo","Descrizione testuale","str","",0,
                   True,None,"",True,"Descrizione testuale")    
    
    def gen(self):
        #aggiungi
        x=self.be['uiutil'].adddialog("Aggiungi","Inserire i dati per aggiungere un nuovo Articolo","articoli/add-db")

        self.field_gen(x)
        self.field_gen_ex(x)
        
        self.addhandler("add",x.handle,"Aggiungi")
        self.addhandler("add-db",self.add_db)

        # modifica
        x=self.be['uiutil'].moddialog("Modifica", "Modifica di un articolo","articoli/mod-db",self.mod_sel)
        
        self.field_gen(x)
        self.field_gen_ex(x)
        self.addhandler("mod",x.handle,"Modifica")
        self.addhandler("mod-db",self.mod_db)

        # listino
        x=self.be['uiutil'].listdialog("Listino articoli","Listino dettagliato articoli", self.list_sel)

        self.field_gen(x)
        
        x.addcommand("articoli/add","Aggiungi","add",update="true")
        x.addcommand("articoli/mod","Modifica","edit",fwsel="codice",update="true",doubleclick="true")
        x.addcommand("articoli/del","Rimuovi","delete",fwsel="codice",update="true")
        #        x.addcommand("articoli/prova","Prova","prova",refattrib={'a':'pippo'})
        x.addcommand("articoli/report","Report","report")
        self.addhandler("report",self.report)
        
        self.addhandler("list",x.handle,"Listino")
        
    def list_sel(self,d,e):
        a=e.attrib ## check also parameters like search or paging

        c=self.db.cursor()
        if a.has_key("fornitore"):
            c.execute("SELECT * FROM articoli_articoli WHERE codice_fornitore='" + self.be['dbutil'].escape_value(a['fornitore']) + "'")
        else:
            c.execute("SELECT * FROM articoli_articoli")
        
        data = c.dictfetchall()
        return data
    

    def mod_sel(self,d,e):
        a=e.attrib 

        c=self.db.cursor()
        c.execute("SELECT * FROM articoli_articoli WHERE codice='" + a['codice'] + "'")
        data = c.dictfetchone()
        
        if data is None: #bail out!!!
            raise Exception("Select call failed! Maybe the item does not exist")
        return data
    
    def add_db(self,d,e):
        a=e.attrib 
        # definisce quali campi si passa ad db
        valuesl=('codice','descrizione','testo','um','tipo','prezzo_std')
        values=self.be['dbutil'].cleanup_field_params(e,valuesl)
        
        c = self.db.cursor()
        # definisce la tabella su cui inserire i dati
        q = self.be['dbutil'].generate_insert_query("articoli_articoli",values)
        
        print "articoli/add-db: query: " + q
        
        c.execute (q)
        self.db.commit()
        
        d._push()
        d.ui(type="message")
        d._pop()

        d._push()
        d.data("Operazione eseguita",type="text")
        d._pop()

        #at top level

    def mod_db(self,d,e):
        a=e.attrib 
        # definisce quali campi si passa ad db
        valuesl=('codice','descrizione','testo','um','tipo','prezzo_std')
        
        values=self.be['dbutil'].cleanup_field_params(e,valuesl)
        
        c = self.db.cursor()
        # definisce la tabella su cui aggiornare i dati
        q = self.be['dbutil'].generate_update_query("articoli_articoli",values,[("codice","=",values['codice'])])
        
        print "articoli/mod-db: query: " + q

        
        c.execute (q)
        self.db.commit()
        
        d._push()
        d.ui(type="message")
        d._pop()

        d._push()
        d.data("Operazione eseguita",type="text")
        d._pop()


    def del_db(self,d,e):
        a=e.attrib 

        c = self.db.cursor()
        
        c.execute ("DELETE FROM articoli_articoli WHERE codice='" +a['codice'] + "'")
        self.db.commit()
        
        print "articoli/del: query: "

        d._push()
        d.ui(type="message")
        d._pop()

        d._push()
        d.data("Operazione eseguita",type="text")
        d._pop()

        #at top level

    def report(self,d,e):
        c=self.db.cursor()
        
        from freereport import *
        ##FIXME We should not use tempnam()
        name=os.tempnam()

        doc=freereport_pdf(a4,name)
        doc.setsize(*a4)
        t=doc.table()
        doc.additem(doc.paragraph("Prova di report sql con la magnifica FREEREPORT by aldox86"))
        t.addrow_txt(["codice","descrizione","um","tipo","prezzo std"])
        
        t.add_from_sql(c,"SELECT codice,descrizione,um,tipo,prezzo_std FROM articoli_articoli")
        
        doc.additem(t)

        doc.generate()
        
        d._push()
        d.ui(type="print")
        d._pop()
        
        from binascii import b2a_base64
        d._push()

        d.data("<![CDATA["+b2a_base64(file(name,"rb").read())+"]]>",format="pdf")
        d._pop()
        
        d._push()
        d.ui(type="print")
        d._pop()


        print 
        
