#! /usr/bin/python

# Copyright (C) 2005 Cristian Greggio

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

from module import *

class handler(module):
    def __init__(self,name,db):
        module.__init__(self,name,"viste",db) # serve a identificare il nome mod
        menuprefix="Viste"
        self.addhandler("list_conti_disp",self.list_conti_disp,menuprefix+"/Lista Conti Disponibilita'")
        self.addhandler("list_fatture_att",self.list_fatture_att,menuprefix+"/Lista Fatture Attive")
        self.addhandler("list_fatture_pas",self.list_fatture_pas,menuprefix+"/Lista Fatture Passive")
        self.addhandler("list_conti",self.list_conti,menuprefix+"/Lista Conti'")
        self.addhandler("list_cont_ven",self.list_cont_ven,menuprefix+"/Lista Movimenti Contabili Vendite")
        self.addhandler("list_cont_acq",self.list_cont_acq,menuprefix+"/Lista Movimenti Contabili Acquisto")
        self.addhandler("list_cont_gen",self.list_cont_gen,menuprefix+"/Lista Movimenti Contabili Generali")
        self.addhandler("list_aliq_iva",self.list_aliq_iva,menuprefix+"/Lista Movimenti Contabili Generali")
        self.addhandler("list_stato_mage",self.list_stato_mage,menuprefix+"/Listastato Magazzino")

    def list_conti_disp(self,d,e):
        a=e.attrib ## check also parameters like search or paging

        d._push()
        d.ui(type="listview")
        
        d._pop()
        
        d._push()
        d.data(type="table")
        #headers
        d._push()
        d.headers()

        d._push()
        d.header(name="codice_conto", title="Codice",type="str") #....
        d._pop()

        d._push()
        d.header(name="descrizione_conto", title="Descrizione", type="str")
        d._pop()

        d._push()
        d.header(name="codice_gifi_conto", title="Conto gifi", type="str")
        d._pop()

        d._pop() #headers

        d._push()
        d.rows()
        c=self.db.cursor()
        c.execute("SELECT * FROM conti_base WHERE codice_conto > 114000 AND codice_conto < 115000 ")
        data = c.dictfetchall()
        for r in data:
            d._push()
            d.row(None,**r)
            d._pop()
        d._pop()

        d._pop()

        #at top level

    def list_conti(self,d,e):
        a=e.attrib ## check also parameters like search or paging

        d._push()
        d.ui(type="listview")
        
        d._pop()
        
        d._push()
        d.data(type="table")
        #headers
        d._push()
        d.headers()

        d._push()
        d.header(name="codice_conto", title="Codice",type="str") #....
        d._pop()

        d._push()
        d.header(name="descrizione_conto", title="Descrizione", type="str")
        d._pop()

        d._push()
        d.header(name="codice_gifi_conto", title="codice_gifi_conto", type="str")
        d._pop()

        d._pop() #headers

        d._push()
        d.rows()
        c=self.db.cursor()
        c.execute("SELECT * FROM conti_base;")
        data = c.dictfetchall()
        for r in data:
            d._push()
            d.row(None,**r)
            d._pop()
        d._pop()

        d._pop()


    def list_fatture_att(self,d,e):
        a=e.attrib ## check also parameters like search or paging

        d._push()
        d.ui(type="listview")
        
        d._pop()
        
        d._push()
        d.data(type="table")
        #headers
        d._push()
        d.headers()

        d._push()
        d.header(name="documento", title="Documento",type="str") #....
        d._pop()

        d._push()
        d.header(name="data", title="Data", type="str")
        d._pop()

        d._push()
        d.header(name="importo_fat", title="Importo Fattura", type="str")
        d._pop()

        d._pop() #headers

        d._push()
        d.rows()
        c=self.db.cursor()
        c.execute("SELECT n AS documento,data,sum(valore_sc_ivato) AS importo_fat FROM val_fatture_atv GROUP BY n, data;")
        data = c.dictfetchall()
        for r in data:
            d._push()
            d.row(None,**r)
            d._pop()
        d._pop()

        d._pop()

    

    def list_fatture_pas(self,d,e):
        a=e.attrib ## check also parameters like search or paging

        d._push()
        d.ui(type="listview")
        
        d._pop()
        
        d._push()
        d.data(type="table")
        #headers
        d._push()
        d.headers()

        d._push()
        d.header(name="n_pas", title="Documento",type="str") #....
        d._pop()

        d._push()
        d.header(name="data_pas", title="Data", type="str")
        d._pop()

        d._push()
        d.header(name="importo_fat", title="Importo Fattura", type="str")
        d._pop()

        d._pop() #headers

        d._push()
        d.rows()
        c=self.db.cursor()
        c.execute("SELECT n_pas,data_pas,sum(valore_ca_ivato) AS importo_fat FROM val_fatture_pas GROUP BY n_pas, data_pas;")
        data = c.dictfetchall()
        for r in data:
            d._push()
            d.row(None,**r)
            d._pop()
        d._pop()

        d._pop()

    def list_cont_ven(self,d,e):
        a=e.attrib ## check also parameters like search or paging

        d._push()
        d.ui(type="listview")
        
        d._pop()
        
        d._push()
        d.data(type="table")
        #headers
        d._push()
        d.headers()

        d._push()
        d.header(name="documento", title="Documento",type="str") #....
        d._pop()

        d._push()
        d.header(name="data", title="Data", type="str")
        d._pop()

        d._push()
        d.header(name="descrizione", title="Descrizione", type="str")
        d._pop()

        d._push()
        d.header(name="conto_contabile", title="Conto", type="str")
        d._pop()

        d._push()
        d.header(name="dare", title="Dare", type="str")
        d._pop()

        d._push()
        d.header(name="avere", title="Avere", type="str")
        d._pop()

        d._pop() #headers

        d._push()
        d.rows()
        c=self.db.cursor()
        c.execute("SELECT * FROM contb_vendite")
        data = c.dictfetchall()
        for r in data:
            d._push()
            d.row(None,**r)
            d._pop()
        d._pop()

        d._pop()

    def list_cont_acq(self,d,e):
        a=e.attrib ## check also parameters like search or paging

        d._push()
        d.ui(type="listview")
        
        d._pop()
        
        d._push()
        d.data(type="table")
        #headers
        d._push()
        d.headers()

        d._push()
        d.header(name="documento", title="Documento",type="str") #....
        d._pop()

        d._push()
        d.header(name="data", title="Data", type="str")
        d._pop()

        d._push()
        d.header(name="descrizione", title="Descrizione", type="str")
        d._pop()

        d._push()
        d.header(name="conto_contabile", title="Conto", type="str")
        d._pop()

        d._push()
        d.header(name="dare", title="Dare", type="str")
        d._pop()

        d._push()
        d.header(name="avere", title="Avere", type="str")
        d._pop()

        d._pop() #headers

        d._push()
        d.rows()
        c=self.db.cursor()
        c.execute("SELECT * FROM contb_acquisto")
        data = c.dictfetchall()
        for r in data:
            d._push()
            d.row(None,**r)
            d._pop()
        d._pop()

        d._pop()

    def list_cont_gen(self,d,e):
        a=e.attrib ## check also parameters like search or paging

        d._push()
        d.ui(type="listview")
        
        d._pop()
        
        d._push()
        d.data(type="table")
        #headers
        d._push()
        d.headers()

        d._push()
        d.header(name="documento", title="Documento",type="str") #....
        d._pop()

        d._push()
        d.header(name="data", title="Data", type="str")
        d._pop()

        d._push()
        d.header(name="descrizione", title="Descrizione", type="str")
        d._pop()

        d._push()
        d.header(name="conto_contabile", title="Conto", type="str")
        d._pop()

        d._push()
        d.header(name="dare", title="Dare", type="str")
        d._pop()

        d._push()
        d.header(name="avere", title="Avere", type="str")
        d._pop()

        d._pop() #headers

        d._push()
        d.rows()
        c=self.db.cursor()
        c.execute("SELECT * FROM contab_gen")
        data = c.dictfetchall()
        for r in data:
            d._push()
            d.row(None,**r)
            d._pop()
        d._pop()

        d._pop()

    def list_aliq_iva(self,d,e):
        a=e.attrib ## check also parameters like search or paging

        d._push()
        d.ui(type="listview")
        
        d._pop()
        
        d._push()
        d.data(type="table")
        #headers
        d._push()
        d.headers()

        d._push()
        d.header(name="codice_iva", title="Codice Iva",type="str") #....
        d._pop()

        d._push()
        d.header(name="descrizione", title="Descrizione", type="str")
        d._pop()

        d._push()
        d.header(name="aliquota", title="Aliquota", type="str")
        d._pop()


        d._pop() #headers

        d._push()
        d.rows()
        c=self.db.cursor()
        c.execute("SELECT * FROM codici_iva")
        data = c.dictfetchall()
        for r in data:
            d._push()
            d.row(None,**r)
            d._pop()
        d._pop()

        d._pop()

    def list_stato_mage(self,d,e):
        a=e.attrib ## check also parameters like search or paging

        d._push()
        d.ui(type="listview")
        
        d._pop()
        
        d._push()
        d.data(type="table")
        #headers
        d._push()
        d.headers()

        d._push()
        d.header(name="codice_magazzino", title="Codice Articolo",type="str") #....
        d._pop()

        d._push()
        d.header(name="tot_giacenze", title="Giacenza", type="str")
        d._pop()

        d._push()
        d.header(name="tot_acquistato", title="Acquistato", type="str")
        d._pop()

        d._push()
        d.header(name="tot_preventivato", title="Preventivato", type="str")
        d._pop()


        d._pop() #headers

        d._push()
        d.rows()
        c=self.db.cursor()
        c.execute("SELECT codice_magazzino, sum(giacenze) AS tot_giacenze,sum(acquistato) AS tot_acquistato, sum(preventivato) AS tot_preventivato FROM vista_ragr_mov_mage GROUP BY codice_magazzino")
        data = c.dictfetchall()
        for r in data:
            d._push()
            d.row(None,**r)
            d._pop()
        d._pop()

        d._pop()
