#! /usr/bin/python

# Copyright (C) 2005 Cristian Greggio

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


### modulo per gli ordini di acquisto

from module import *

class handler(module):
    def __init__(self,name,db):
        # richiama i moduli per l'ordine d'acquisto
        module.__init__(self,name,"vendite",db)
        self.addhandler("list_oda",self.list_oda,"Lista ODA")
        self.addhandler("add-db_oda",self.add_db_oda)
        self.addhandler("mod_oda",self.mod_oda)
        self.addhandler("mod_db_oda",self.mod_db_oda)
        self.addhandler("add_oda",self.add_oda, "ADD ODA")
        self.addhandler("list",self.list,"Lista")
        self.addhandler("add",self.add)
        self.addhandler("add-db",self.add_db)
        self.addhandler("mod",self.mod)
        self.addhandler("mod-db",self.mod_db)
        self.addhandler("del",self.del_db)
        self.addhandler("test",self.test2, "TEST")


### parte degli ordini d'acquisto ####
        
    def list_oda(self,d,e):
        a=e.attrib ## check also parameters like search or paging

        d._push()
        d.ui(type="listview")
        # definisce i comandi e cosa devono fare
        d._push()
        d.command(stock="add",action="vendite/add_oda",update="true")
        d._pop()
        #d._push()
        #d.command(stock="delete",action="oda2/mod_oda",forwardselection="id_oda",update="true")
        #d._pop()
        d._push()
        d.command(stock="edit",action="vendite/mod_oda",forwardselection="id_oda",update="true")
        d._pop()

        d._push()
        d.command(stock="edit",action="vendite/list",forwardselection="id_oda",update="true")
        d._pop()

        d._pop()
        
        d._push()
        d.data(type="table")
        #headers
        d._push()
        d.headers()
        # definisce le caselle che si devono vedere type deve essere str
        d._push()
        d.header(name="id_oda", title="Numero Ordine", type="str")
        d._pop()

        d._push()
        d.header(name="codice_fornitore", title="Codice Fornitore",type="str") #....
        d._pop() 

        d._push()
        d.header(name="stato_oda", title="Stato Ordine",type="str") #....
        d._pop()


        d._pop() #headers

        d._push()
        d.rows()

        # definisce la tabella o la vista da dove leggere
        c=self.db.cursor()
        c.execute("SELECT * FROM ordine_acquisto")
        data = c.dictfetchall()
        for r in data:
            d._push()
            d.row(None,**r)
            d._pop()
        d._pop()

        d._pop()

    def add_oda(self,d,e):
        a=e.attrib 

        # definisce la vista add
        
        d._push()
        d.ui(type="amwindow")
        d._push()
        d.dialog(action="pos_oda/add-db_oda", type="add")
        d._pop()

        d._push()
        d.title("Aggiungi Un ordine di d'acquisto")
        d._pop()
        
        d._push()
        d.msg("Inserire Oda")
        d._push()
        
        d._push()
        d.field(name="codice_fornitore", title="Codice Fornitore", type='str',
                           defvalue="",optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()


        d._push()
        d.field(name="stato_oda", title="Stato Ordine", type='str',
                           defvalue="",optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()

        d._pop() # ui
        
        d._push()
        d.data()
        d._pop()

    def mod_oda(self,d,e):
        a=e.attrib 
        c=self.db.cursor()
        c.execute("SELECT * FROM ordine_acquisto WHERE id_oda='" + a['id_oda'] + "'")
        data = c.dictfetchone()

        if data is None: #bail out!!!
            raise Exception("Select call failed!!") 

        # definisce la vista add
        
        d._push()
        d.ui(type="amwindow")
        d._push()
        d.dialog(action="oda2/mod_db_oda", type="mod")
        d._pop()

        d._push()
        d.title("Aggiungi Un ordine di d'acquisto")
        d._pop()
        
        d._push()
        d.msg("Inserire Oda")
        d._push()

        d._push()
        d.field(name="id_oda", title="Numero Ordine", type='str',
                           defvalue=data['id_oda'],optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()

        
        d._push()
        d.field(name="codice_fornitore", title="Codice Fornitore", type='str',
                           defvalue=data['codice_fornitore'],optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()


        d._push()
        d.field(name="stato_oda", title="Stato Ordine", type='str',
                           defvalue=data['stato_oda'],optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()

        d._pop() # ui
        
        d._push()
        d.data()
        d._pop()

    def mod_db_oda(self,d,e): # definisce cosa modificare

        a=e.attrib
        # queste e' la lista dei malori da modificare
        valuesl=('id_oda','codice_fornitore','stato_oda')
        values={}
        for i in valuesl:
            values[i]=''

        for i in e.getchildren():
            if i.tag=='field':
                if values.has_key(i.attrib['name']):
                    values[i.attrib['name']]=i.attrib['value']
            else:
                print "Warning: unknown tag " + i.tag

        print values
        c = self.db.cursor()

        q = "UPDATE ordine_acquisto SET "
        for k,v in values.iteritems():
            q+= k + '=' + "'" + v + "',"
        
        q=q[:-1]+" WHERE id_oda ='" + values['id_oda'] + "'"
        
        print "pos_oda/mod-db: query: " + q

        
        c.execute (q)
        self.db.commit()
        
        d._push()
        d.ui(type="message")
        d._pop()

        d._push()
        d.data("Operazione eseguita",type="text")
        d._pop()



    def add_db_oda(self,d,e): # definisce cosa inserire
        a=e.attrib 

        valuesl=('codice_fornitore','stato_oda')
        values={}
        for i in valuesl:
            values[i]=''

        for i in e.getchildren():
            if i.tag=='field':
                if values.has_key(i.attrib['name']):
                    values[i.attrib['name']]=i.attrib['value']
            else:
                print "Warning: unknown tag " + i.tag

        print values
        c = self.db.cursor()

        q = "INSERT INTO ordine_acquisto ("
        for i in values.iterkeys():
            q+=i + ','    
        q=q[:-1]+') VALUES ('
        
        for i in values.itervalues():
            q+="'" + i + "'" + ","

        q=q[:-1]+')'
        print "pos_oda/add-db: query: " + q

        
        c.execute (q)
        
        self.db.commit()
        
        d._push()
        d.ui(type="message")
        d._pop()

        d._push()
        d.data("Operazione eseguita",type="text")
        d._pop()

        #at top level

####### parte pos ordini ######

                # crea la lista principale
    def list(self,d,e):
        a=e.attrib ## check also parameters like search or paging
        filtro = a['id_oda']
        d._push()
        d.ui(type="listview")
        # definisce i comandi e cosa devono fare
        d._push()
        d.command(stock="add",action="pos_oda/add",update="true")
        d._pop()
        d._push()
        d.command(stock="delete",action="pos_oda/del",forwardselection="item_pos_oda",update="true")
        d._pop()
        d._push()
        d.command(stock="edit",action="pos_oda/mod",forwardselection="item_pos_oda",update="true")
        d._pop()

        d._pop()
        
        d._push()
        d.data(type="table")
        #headers
        d._push()
        d.headers()
        # definisce le caselle che si devono vedere type deve essere str
        d._push()
        d.header(name="numero_oda", title=filtro, type="str")
        d._pop()

        d._push()
        d.header(name="item_pos_oda", title="Numero Pos.",type="str") #....
        d._pop()

        d._push()
        d.header(name="articolo", title="articolo", type="str")
        d._pop()

        d._push()
        d.header(name="codice_fornitore", title="codice fornitore", type="str")
        d._pop()

        d._push()
        d.header(name="quantita", title="quantita'", type="str")
        d._pop()

        d._push()
        d.header(name="prezzo", title="prezzo", type="str")
        d._pop()

        d._push()
        d.header(name="sconto", title="articolo", type="str")
        d._pop()

        d._push()
        d.header(name="iva", title="iva", type="str")
        d._pop()

        d._pop() #headers

        d._push()
        d.rows()

        # definisce la tabella o la vista da dove leggere
        c=self.db.cursor()
        c.execute("SELECT * FROM posizioni_oda WHERE numero_oda ='4'")
        #query = "SELECT * FROM posizioni_oda WHERE numero_oda='" + a['id_oda'] + "'"
        c.execute("SELECT * FROM posizioni_oda WHERE numero_oda='" + a['id_oda'] + "'")
        #print query
        #c.execute(query)

        data = c.dictfetchall()
        for r in data:
            d._push()
            d.row(None,**r)
            #d.row(r)
            d._pop()
        d._pop()

        d._pop()

        #at top level

    def add(self,d,e):
        a=e.attrib 

        # definisce la vista add
        
        d._push()
        d.ui(type="amwindow")
        d._push()
        d.dialog(action="pos_oda/add-db", type="add")
        d._pop()

        d._push()
        d.title("Aggiungi Posizione a Ordine acquisto")
        d._pop()
        
        d._push()
        d.msg("Inserire i dati per aggiungere un nuovo utente")
        d._push()
        
        d._push()
        d.field(name="numero_oda", title="Numero Ordine", type='str',
                           defvalue="",optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()
        
        d._push()
        d.field(name="item_pos_oda", title="Posizione",  type='str',
                           defvalue="",optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()

        d._push()
        d.field(name="articolo", title="Articolo", type='str',
                           defvalue="",optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()
        
        d._push()
        d.field(name="codice_fornitore", title="Codice Fornitore",  type='str',
                           defvalue="",optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()


        d._push()
        d.field(name="quantita", title="Quantita'", type='int',
                           defvalue="",optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()
        
        d._push()
        d.field(name="prezzo", title="prezzo",  type='int',
                           defvalue="",optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()

        d._push()
        d.field(name="sconto", title="sconto", type='int',
                           defvalue="",optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()
        
        d._push()
        d.field(name="iva", title="iva",  type='int',
                           defvalue="",optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()

        d._pop() # ui
        
        d._push()
        d.data()
        d._pop()
        
        

        #at top level




    def mod(self,d,e):
        a=e.attrib 
        print "item: ", a['item_pos_oda']
        c=self.db.cursor()
        c.execute("SELECT * FROM posizioni_oda WHERE item_pos_oda='" + a['item_pos_oda'] + "'")
        data = c.dictfetchone()

        if data is None: #bail out!!!
            raise Exception("Select call failed!!")
            

        d._push()
        d.ui(type="amwindow")
        d._push()
        d.dialog(action="pos_oda/mod-db", type="mod")
        d._pop()

        d._push()
        d.title("Modifica Posizione Ordine")
        d._pop()
        
        d._push()
        d.msg("Modifica Posizione Ordine")
        d._push()
        
        d._push()
        d.field(name="numero_oda", title="Numero_oda", type='str',
                           defvalue=data['numero_oda'],optional=False, readonly=True,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()
        
        d._push()
        d.field(name="item_pos_oda", title="Item",  type='str',
                           defvalue=data['item_pos_oda'],optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()

        d._push()
        d.field(name="articolo", title="Articolo", type='str',
                           defvalue=data['articolo'],optional=False, readonly=True,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()
        
        d._push()
        d.field(name="codice_fornitore", title="Codice Fornitore",  type='str',
                           defvalue=data['codice_fornitore'],optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()

        d._push()
        d.field(name="quantita", title="quantita",  type='int',
                           defvalue=data['quantita'],optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()

        d._push()
        d.field(name="prezzo", title="prezzo",  type='int',
                           defvalue=data['prezzo'],optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()

        d._push()
        d.field(name="sconto", title="sconto",  type='int',
                           defvalue=data['sconto'],optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()

        d._push()
        d.field(name="iva", title="iva",  type='int',
                           defvalue=data['iva'],optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()
        
        d._pop() # ui
        
        d._push()
        d.data()
        d._pop()
        
        

        #at top level

    def add_db(self,d,e): # definisce cosa inserire
        a=e.attrib 

        valuesl=('numero_oda','item_pos_oda','codice_fornitore','quantita', 'prezzo','sconto','iva','articolo')
        values={}
        for i in valuesl:
            values[i]=''

        for i in e.getchildren():
            if i.tag=='field':
                if values.has_key(i.attrib['name']):
                    values[i.attrib['name']]=i.attrib['value']
            else:
                print "Warning: unknown tag " + i.tag

        print values
        c = self.db.cursor()

        q = "INSERT INTO posizioni_oda ("
        for i in values.iterkeys():
            q+=i + ','    
        q=q[:-1]+') VALUES ('
        
        for i in values.itervalues():
            q+="'" + i + "'" + ","

        q=q[:-1]+')'
        print "pos_oda/add-db: query: " + q

        
        c.execute (q)
        self.db.commit()
        
        d._push()
        d.ui(type="message")
        d._pop()

        d._push()
        d.data("Operazione eseguita",type="text")
        d._pop()

        #at top level

    def mod_db(self,d,e): # definisce cosa modificare

        a=e.attrib
        # queste e' la lista dei malori da modificare
        valuesl=('numero_oda','item_pos_oda','codice_fornitore','quantita', 'prezzo','sconto','iva','articolo')
        values={}
        for i in valuesl:
            values[i]=''

        for i in e.getchildren():
            if i.tag=='field':
                if values.has_key(i.attrib['name']):
                    values[i.attrib['name']]=i.attrib['value']
            else:
                print "Warning: unknown tag " + i.tag

        print values
        c = self.db.cursor()

        q = "UPDATE posizioni_oda SET "
        for k,v in values.iteritems():
            q+= k + '=' + "'" + v + "',"
        
        q=q[:-1]+" WHERE item_pos_oda ='" + values['item_pos_oda'] + "'"
        
        print "pos_oda/mod-db: query: " + q

        
        c.execute (q)
        self.db.commit()
        
        d._push()
        d.ui(type="message")
        d._pop()

        d._push()
        d.data("Operazione eseguita",type="text")
        d._pop()


    def del_db(self,d,e): #definisce cosa cancellare
        a=e.attrib 
        c = self.db.cursor()
        q="DELETE FROM posizioni_oda WHERE item_pos_oda='" +a['item_pos_oda'] + "'"
        c.execute (q)
        self.db.commit()
        
        print "utenti/del: query: " + q

        d._push()
        d.ui(type="message")
        d._pop()

        d._push()
        d.data("Operazione eseguita",type="text")
        d._pop()

        #at top level

    def test(self,d,e):
        a=e.attrib    

        query = "SELECT * FROM posizioni_oda WHERE numero_oda='" + a['id_oda'] + "'"



        print query
        c = self.db.cursor()
        c.execute(query)
        data = c.dictfetchall()

        result = data

        for r in data:
            d._push()
            d.row(None,**r)
            d._pop()

        
        d._push()
        d.ui(type="amwindow")
        d._push()
        d.dialog(action="pos_oda/add-db", type="add")
        d._pop()

        d._push()
        d.title("Aggiungi Posizione a Ordine acquisto")
        d._pop()
        
        d._push()
        d.msg("Inserire i dati per aggiungere un nuovo utente")
        d._push()
        
        d._push()
        d.field(name="qyery", title="query", type='str',
                           defvalue=query,optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()
        d._push()

        d.field(name="result", title="result", type='str',
                           defvalue=result,optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()        

        d._pop() # ui
        
        d._push()
        d.data()
        d._pop()
        

    def test2(self,d,e):
        a=e.attrib ## check also parameters like search or paging

        d._push()
        d.ui(type="listview")

#        d._push()
#        d.command(stock="add",action="articoli/add",update="true")
#        d._pop()
#        d._push()
#        d.command(stock="delete",action="articoli/del",forwardselection="codice",update="true")
#        d._pop()
#        d._push()
#        d.command(stock="edit",action="articoli/mod",forwardselection="codice",update="true")
#        d._pop()

        d._pop()
        
        d._push()
        d.data(type="table")
        #headers
        d._push()
        d.headers()

        d._push()
        d.header(name="codice",type="str") #....
        d._pop()

        #d._push()
        #d.header(name="descrizione", type="str")
        #d._pop()

        #d._push()
        #d.header(name="prezzo", type="str")
        #d._pop()

        d._pop() #headers

        d._push()
        d.rows()
        #d.row(codice="ciao", descrizione="mdweofdmwe", prezzo="troppo")
        d.row(codice=a['id_oda'])
        d._pop()

        d._pop()

        #at top level

        
