#! /usr/bin/python
# -*- coding: iso-8859-15 -*-

# Copyright (C) 2006 Aldo Nicolas Bruno

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


### TODO IMPROVE READONLY MECHANISMS IN ADD AND MOD DIALOGS.... (security issues pending)

from module import *


## TODO scrivere la documentazione qui
class field:
    def __init__ (self,name,title,type,defvalue,maxlen=0,optional=True,password=None,help="",multiline=False,tooltip="",ref=None,refname=None,refattrib={},readonly=False,fkey=None,pkey=False,check=None,autokey=False,fwvalue=None,metadata="",hidden=False,fwfields='',refupdate='',reftype=None):
        self.name=name
        self.title=title
        self.type=type
        self.defvalue=defvalue
        
        self.optional=optional
        self.help=help.replace("\n","\\n")
        self.multiline=multiline
        self.tooltip=tooltip
        self.ref=ref
        self.refname=refname
        self.refattrib=refattrib
        self.maxlen=maxlen
        self.readonly=readonly
        self.fkey=fkey
        self.pkey=pkey
        self.check=check
        self.autokey=autokey
        self.fwvalue=fwvalue
        self.metadata=str(metadata)
        self.hidden=hidden

        self.fwfields=fwfields
        self.refupdate=refupdate

        self.reftype=reftype

    def xml_field(self,d,a=None):
        e={}
        e['name']=self.name
        e['title']=self.title
        e['type']=self.type
        
        dv=self.defvalue

        if type(self.defvalue).__name__  == 'function':
            dv=self.defvalue()

        if self.multiline:
            dv=dv.replace("\n","\\n")
        
        e['defvalue']=dv
        e['maxlen']=self.maxlen
        e['optional']=self.optional
        e['help']=self.help
        e['multiline']=self.multiline
        e['tooltip']=self.tooltip
        e['readonly']=self.readonly
        e['hidden']=self.hidden
        e['fwfields']=self.fwfields
        
        if self.ref is not None:
            e['ref']=self.ref
            e['refupdate']=self.refupdate
            if self.refname is not None:
                e['refname']=self.refname
            if self.reftype is not None:
                e['reftype']=self.reftype

        if self.fwvalue is not None:
            print a
            if a is not None and a.has_key(self.fwvalue):
                e['defvalue']=a[self.fwvalue]
            else:
                print "Warning fwvalue given but parameter is missing: "+str(self.fwvalue)

        d.field(**e)
        
        if self.ref is not None and len(self.refattrib)>0:
            d._push()
            d.attrib(**self.refattrib)
            d._pop()

        if len(self.metadata)>0:
            d._push()
            d.metadata("<[CDATA["+self.metadata+"]]>")
            d._pop()
            
    def xml_header(self,d):
        e={}
        e['name']=self.name
        e['title']=self.title
        e['type']=self.type
        if self.type == 'float':
            e['precision']=self.maxlen
        d.header(**e)
        
class dialog:
    def __init__(self,title,msg,action,menuprefix=None):
        self.title=title
        self.msg=msg
#        self.handler=handler
        self.fields=[]
        self.action=action
        self.menuprefix=menuprefix
        self.handlehook=None
        
    def handle(self,d,e):
        if self.handlehook is not None:
            self.handlehook(d,e)

    def handledb(self,d,e):
        pass

    def addfield(self,*v,**kv):
        self.fields.append(field(*v,**kv))
        

class adddialog(dialog):
    def __init__(self,title,msg,action):
        dialog.__init__(self,title,msg,action)

    def handle(self,d,e):
        dialog.handle(self,d,e)
        a=e.attrib

        d._push()
        d.ui(type="amwindow")
        d._push()

        d.dialog(action=self.action, type="add")

        d._pop()

        d._push()
        d.title(self.title)
        d._pop()

        d._push()
        d.msg(self.msg)

        d._push()

        for h in  self.fields:
            d._push()
            h.xml_field(d,a)
            d._pop()

        d._pop() # ui

        d._push()
        d.data()
        d._pop()

class moddialog(dialog):
    def __init__(self,title,msg,action,selhandler,uihandler=None,readonlycb=None):
        dialog.__init__(self,title,msg,action)
        self.selhandler=selhandler
        self.uihandler=uihandler
        self.readonlycb=readonlycb
        
    def handle(self,d,e):
        dialog.handle(self,d,e)
        if self.uihandler is not None:
            r=self.uihandler(self,d,e)
            if r and (r is not None):
                return True

        p=False
        if self.readonlycb is not None:
            p=self.readonlycb(d,e)
         
        a=e.attrib
        x=self.selhandler
        l=x(d,e)
        
        d._push()
        d.ui(type="amwindow")
        d._push()

        t=''
        
        if p:
            t='view'
        else:
            t='mod'
            
        d.dialog(action=self.action, type=t)

        d._pop()

        d._push()
        d.title(self.title)
        d._pop()

        d._push()
        d.msg(self.msg)

        d._push()

        for h in  self.fields:
            d._push()
            h.defvalue=l[h.name]
            h.xml_field(d,a)
            d._pop()

        d._pop() # ui

        d._push()
        d.data()
        d._pop()

class viewdialog(dialog):
    def __init__(self,title,msg,action,selhandler):
        dialog.__init__(self,title,msg,action)
        self.selhandler=selhandler
 
    def handle(self,d,e):
        dialog.handle(self,d,e)
        a=e.attrib
        x=self.selhandler
        l=x(d,e)
        
        d._push()
        d.ui(type="amwindow")
        d._push()

        d.dialog(action=self.action, type="view")

        d._pop()

        d._push()
        d.title(self.title)
        d._pop()

        d._push()
        d.msg(self.msg)

        d._push()

        for h in  self.fields:
            d._push()
            h.defvalue=l[h.name]
            h.xml_field(d,a)
            d._pop()

        d._pop() # ui

        d._push()
        d.data()
        d._pop()

class command:
    def __init__ (self,action,title,stock=None,fwsel=None,update=True,doubleclick=False,refattrib={},fwparam=None,confirm=None):
        self.action=action
        self.title=title
        self.stock=stock
        self.fwsel=fwsel
        self.update=update
        self.doubleclick=doubleclick
        self.refattrib=refattrib
        self.fwparam=fwparam
        self.confirm=confirm
        
    def xml(self,d):
        e={}
        if self.stock is not None:
            e['stock']=self.stock
        e['action']=self.action
        e['title']=self.title

        if self.fwsel is not None:
            e['forwardselection']=self.fwsel
        if self.fwparam is not None:
            e['forwardparameter']=self.fwparam
        if self.confirm is not None:
            e['confirm']=self.confirm
        e['update']=self.update
        e['doubleclick']=self.doubleclick
        
        d.command(**e)
    
        if len(self.refattrib)>0:
            d.attrib(**self.refattrib)        

class listdialog(dialog):
    def __init__(self,title,msg,selhandler):
        dialog.__init__(self,title,msg,None)
        self.selhandler=selhandler
        self.commands=[]

    def addcommand(self,*v,**kv):
        self.commands.append(command(*v,**kv))

    def getcommand(self,action):
        for a in self.commands:
            if a.action==action:
                return a

    def handle(self,d,e):
        dialog.handle(self,d,e)
        
        a=e.attrib

        d._push()
        d.ui(type="listview")

        for x in self.commands:
            d._push()
            x.xml(d)
            d._pop()

        d._push()
        d.title(self.title)
        d._pop()

        d._push()
        d.msg(self.msg)
        d._pop()

        d._pop() # ui

        d._push()
        d.data(type="table")
        #headers
        d._push()
        d.headers()
        for h in self.fields:
            d._push()
            h.xml_header(d)
            d._pop()

        d._pop() #headers
        
        d._push()
        d.rows()
        
        x=self.selhandler
        data=x(d,e)
        
        for r in data:
            d._push()
            d.row(None,**r)
            d._pop()
        d._pop() #rows

        d._pop() #data
        #print str(d)


class simpleview(listdialog):
    def __init__(self,title,msg,mod,res,fields,query,menu=None):
        listdialog.__init__(self,title,msg,self.sel_db)
        self.mod=mod
        self.res=res
        self.query=query
        for f in fields:
            self.addfield(**f)
        x=menu
        if x is None:
            mod.addhandler(res,self.handle)
        else:
            mod.addhandler(res,self.handle,x)
        
    def sel_db(self,d,e):
        c=self.mod.db.cursor()
        try: 
            c.execute(self.query)
        except Exception,e:
            raise SoftException("Errore in simpleview.sel_db(): "+str(e))
        return c.dictfetchall()
    
class simpledbmodule(module):
    def __init__(self,name,title,be,fields,add=True,mod=True,list=True,delete=False,table=None,menu=None,sort=""):
        module.__init__(self,name,title,be)

        self.table=table
        
        self.fields=fields
        self.fields[0]['pkey']=True
        self.key=self.fields[0]['name']
        
        self.add=add
        self.mod=mod
        self.list=list
        self.delete=delete

        self.sort=sort
        
        self.menuprefix=menu
        
        if add:
            self.gen_add()
        if mod:
            self.gen_mod()
        if list:
            self.gen_list()
        if delete:
            self.gen_del()

        self.gen()

    def generate_db(self):
        if self.table is not None:
            return self.be['dbutil'].generate_create_table(self.table,self.fields)
        return ""

    def gen_add(self):
        x=adddialog(self.title+": Aggiungi","Inserire i dati per aggiungere un nuovo elemento",self.name+"/add-db")

        if self.fields[0].has_key('autokey')and self.fields[0]['autokey']:
            l=self.fields[1:]
        else:
            l=self.fields
        
        for f in l:
            x.addfield(**f)

        if self.menuprefix is None:
            self.addhandler("add",x.handle)
        else:
            self.addhandler("add",x.handle,self.menuprefix+"/Aggiungi")

        self.addhandler("add-db",self.add_db)
        
        self.add_dialog=x

    def add_db(self,d,e):
        if self.table is None:
            raise Exception("Not implemented! :(")

        valuesl=[]
        for f in self.fields:
            if not (f.has_key('autokey') and f['autokey']):
                valuesl.append(f['name'])
        
        values=self.be['dbutil'].cleanup_field_params(e,valuesl)

        c = self.db.cursor()
        
        q = self.be['dbutil'].generate_insert_query(self.table,values)
        
        print self.name+"/add-db: query: " + q

#        self.db.begin()
        c.execute (q)

        if not values.has_key(self.key):
            ## prendiamo il valore dal db perche e stato appena generato
            c.execute("SELECT MAX("+self.key+") FROM "+self.table)
            values[self.key]=c.fetchone()[0]
        self.db.commit()

        self.add_db_complete(d,e,values)
    
        #at top level
    def add_db_complete(self,d,e,values):
        d._push()
        d.ui(type="message")
        d._pop()
        msg=self.title+": Inserimento completato: " +str(values[self.key])
        d._push()
        d.data(msg,type="text")
        d._pop()        
        
    def gen_mod(self):
        x=moddialog(self.title+": Modifica", "Modifica di un elemento",self.name+"/mod-db",self.mod_sel)

        
        for f in self.fields:
            x.addfield(**f)

        x.fields[0].readonly=True
        
        self.addhandler("mod",x.handle)
        self.addhandler("mod-db",self.mod_db)
        self.mod_dialog=x
        
    def mod_sel(self,d,e):
        a=e.attrib
        
        if self.table is None:
            raise Exception("Not implemented! :(")
        
        c=self.db.cursor()
        c.execute("SELECT * FROM %s WHERE %s = '%s'" %
                  (self.table,
                   self.key,
                   self.be['dbutil'].escape_value(a[self.key])
                   )
                  )
        
        data = c.dictfetchone()

        if data is None: 
            raise SoftException("Select call failed! Maybe the item does not exist")
        return data
        
    def mod_db(self,d,e):
        if self.table is None:
            raise Exception("Not implemented! :(")
        
        # definisce quali campi si passa ad db
        valuesl=[]
        for a in self.fields:
            if a['name']==self.key or not (a.has_key('readonly') and a['readonly']):
                valuesl.append(a['name'])
        
        values=self.be['dbutil'].cleanup_field_params(e,valuesl)
        
        c = self.db.cursor()
        # definisce la tabella su cui aggiornare i dati
        
        q = self.be['dbutil'].generate_update_query(self.table,values,[(self.key,"=",values[self.key])])
        
        print self.name+"/mod-db: query: " + q
        
        c.execute (q)
        self.db.commit()

        self.mod_db_complete(d,e,values)
        
    def mod_db_complete(self,d,e,values):
        d._push()
        d.ui(type="message")
        d._pop()
        
        msg=self.title+": Elemento modificato: "+ str(values[self.key])
        
        d._push()
        d.data(msg,type="text")
        d._pop()        
        
    def gen_list(self):
        x=listdialog("Lista "+self.title,"", self.list_sel)

        for f in self.fields:
            x.addfield(**f)

        self.gen_commands(x)
        if self.menuprefix is None:
            self.addhandler("list",x.handle)
        else:
            self.addhandler("list",x.handle,self.menuprefix+"/Lista")
        self.list_dialog=x
        
    def gen_commands(self,x):
        l=""
        for f in self.fields:
            if f.has_key('fwvalue') and f['fwvalue'] is not None:
                
                l+=str(f['fwvalue'])+","
        if len(l)==0:
            l=None
        
        if self.add:
            x.addcommand(self.name+"/add","Aggiungi","add",update="true",fwparam=l)
        if self.mod:
            x.addcommand(self.name+"/mod","Modifica","edit",fwsel=self.key,update="true",doubleclick="true",fwparam=l)
        if self.delete:
            x.addcommand(self.name+"/del","Rimuovi","delete",fwsel=self.key,update="true",fwparam=l,confirm="Sicuro di voler eliminare l'elemento?")

    def list_sel(self,d,e):
        if self.table is None:
            raise SoftException("Not implemented! in simbledbdialog.list_sel: self.table is None! :(")
        print e.attrib
        c=self.db.cursor()
        
        x=""

        for a in self.fields[:-1]:
            x+=a['name']+","
        x+=self.fields[-1]['name']

        q="SELECT %s FROM %s" % (x,self.table)
        if self.sort != '':
            q+= " ORDER BY " +self.sort
        c.execute(q)

        data = c.dictfetchall()
        
        return data
    
    def gen_del(self):
        self.addhandler("del",self.del_db)

    def del_db(self,d,e):
        a=e.attrib 
                
        c = self.db.cursor()

        key=self.be['dbutil'].escape_value(a[self.key])
        c.execute("BEGIN")
        c.execute ("DELETE FROM %s WHERE %s='%s'"%(self.table,self.key,key))
        c.execute("COMMIT")

        d._push()
        d.ui(type="message")
        d._pop()

        d._push()
        d.data(self.title+": Elemento %s rimosso"%str(a[self.key]),type="text")
        d._pop()
        
        #at top level
        
    def gen(self): # virtual: additional initialization 
        pass
    

class handler(module):
    def __init__(self,name,be):
        module.__init__(self,name,"UI UTILITIES",be)
        self.field=field
        self.dialog=dialog
        self.adddialog=adddialog
        self.moddialog=moddialog
        self.viewdialog=viewdialog
        self.listdialog=listdialog
        self.simpleview=simpleview
        self.simpledbmodule=simpledbmodule
