#! /usr/bin/python
# -*- coding: iso-8859-15 -*-

# Copyright (C) 2006 Aldo Nicolas Bruno

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import copy
from elementtree import ElementTree
import jaxml

from module import *
import os
#import cairo
#import cairo.svg
from tempfile import NamedTemporaryFile
import string
import xml.dom.minidom

class handler(module):
    def __init__(self,name,be):
        module.__init__(self,name,"SVG templates Support",be)

    def _recursive_shit(self,item,vars,foundlist):
        c=item.childNodes

        try:
            id=item.getAttribute('id')
        except:
            id=None

        if item.nodeType==xml.dom.Node.TEXT_NODE:
            return
        
        if id in vars:
            foundlist[id]=item
        else:
            for i in vars:
#                print i,vars[i]
                if isinstance(vars[i], tuple):
                    if id == vars[i][0] or \
                       id == vars[i][1] or \
                       id in vars[i][2][0]:
                        foundlist[id]=item

        for v in c:
            self._recursive_shit(v,vars,foundlist)

    def _set_text(self,item,text):
        if item.hasChildNodes():
            fc=item.firstChild
            if fc.localName=='tspan':
                if fc.hasChildNodes():
                    fc.firstChild.data=text
                else:
                    fc.appendChild(tree.createTextNode(text))

            elif fc.nodeName=='#text':
                item.data=text
            else:
                print "svg.py: Warning tag unknown for text: " + item.tagName
        else:
            item.appendChild(tree.createTextNode(text))

    def _set_image(self,item,file):
        v=file.split(',')
        name=v[0]
        w=v[1]
        h=v[2]
        item.setAttribute('xlink:href',self.be.attrs['docroot']+"/"+name)
        item.setAttribute('width',w)
        item.setAttribute('height',h)

    def _process_table(self,tree,vars,foundlist,v):
        lim=foundlist[v[0]] # str
        row=foundlist[v[1]] # str
        pos=v[2] # list dict
        limh=float(lim.getAttribute('height'))
        rowh=float(row.getAttribute('height'))

        r=int(limh/rowh)

        for i in range(0,r):
            if i % 2 == 0:
                o=row.cloneNode(True)
                y=str(float(o.getAttribute('y'))+rowh*i)
                o.setAttribute('y',y)
                row.parentNode.appendChild(o)
        
        n=len(pos)
        if (n>r and n%r!=0) or n<r:
            M=n/r+1
        else:
            M=n/r

        l=[]

        row.parentNode.removeChild(row)
        lim.parentNode.removeChild(lim)
        
        #for j,k in pos[0].iteritems():
        #    foundlist[j].parentNode.removeChild(foundlist[j])
        print "********************************M e' %d n e' %d r e' %d" %(M,n,r)


        for m in range(0,M):
            u=copy.deepcopy(tree)
            xlist={}
            self._recursive_shit(u.documentElement,vars,xlist)
            
            for count,i in enumerate(pos[r*m:r*(m+1)]):
                for j,k in i.iteritems():
                    o=xlist[j].cloneNode(True)
                    y=str(float(o.getAttribute('y'))+rowh*count)
                    o.setAttribute('y',y)
                    if o.hasChildNodes() and o.firstChild.localName=='tspan':
                        o.firstChild.setAttribute('y',y)
                    self._set_text(o,str(k))
                    xlist[j].parentNode.appendChild(o)
            for j,k in pos[0].iteritems():
                xlist[j].parentNode.removeChild(xlist[j])

            if xlist.has_key('pag'):
                self._set_text(xlist['pag'],'%d/%d'%(m+1,M))

            l.append(u)

        return l

    def _process_vars(self,tree,vars,foundlist):
        mainlist=None
        for id in vars:
            if isinstance (vars[id],tuple):

                continue
            try:
                item=foundlist[id]
            except KeyError:
                print "Warning: missing id in svg template " + id
                continue
            
            if item.localName=='text':
                self._set_text(item,vars[id])
                
            elif item.localName=='image':
                self._set_image(item,vars[id])

            else:
                print "Warning: unknown tag " + item.tagName + "!"
    
    def _process_pages(self,tree,vars,foundlist):
        for id in vars:
            if isinstance(vars[id],tuple):
                return self._process_table(tree,vars,foundlist,vars[id])

    def renderpdf(self,template,vars,n=1):
        x=self.be.attrs['docroot'] + "/" + template

        try:
            tree=xml.dom.minidom.parse(x)
        except Exception,detail:
            raise SoftException(detail)

        foundlist={}
        vars['pag']=""

        self._recursive_shit(tree.documentElement,vars,foundlist)

        self._process_vars(tree,vars,foundlist)
        
        l=self._process_pages(tree,vars,foundlist)

        m=[]
        v=[]
        for t in l:
            buff=t.toxml()

            f=NamedTemporaryFile()
            name=f.name
            f.write(buff)
            
            f.flush()
            m.append(name)
            v.append(f)

        
        if len(l)<1:
            print "Errore: Lista vuota!!!"
            return ""
        
        try:
            q=self.be['dbutil'].fetch_config()['rsvg-convert']
        except Exception,e:
            q="rsvg-convert -f pdf %s"
            print str(e)

        q=q.replace("%s",str(" ".join(m)+" ")*n)
        print q
        g=os.popen(q)
        s=g.read()
        
#	os.system ( "cp %s /tmp/svg" % name)
        g.close()
        for i in v:
            i.close()
        
        return s
