#! /usr/bin/python
# -*- coding: iso-8859-15 -*-

# Copyright (C) 2006 Aldo Nicolas Bruno

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

from ui import field

from module import *
import datetime
import string

# class dbentity:
#     def __init__ (self,name,logged=True):
#         self.logged=logged

# class dbfield:
#     def __init__(self,name,type,optional=False,pkey=None,fkey=None,check=None,autokey=True):
#         self.name=name
#         self.type=type
#         self.optional=optional
#         self.pkey=pkey
#         self.fkey=fkey
#         self.check=check
#         self.autokey=autokey

# class field(dbfield):
#     def __init__(self,name,type,optional=False,pkey=None,fkey=None,check=None,autokey=True,title,optional,readonly,help,tooltip,ref,refname,refattrib):
#         def
        
        

class handler(module):
    def __init__(self,name,be):
        module.__init__(self,name,"DB UTILITIES",be)

    def cleanup_field_params(self,xml,valid_list):
        values={}
        for i in valid_list:
            values[i]=''

        for i in xml.getchildren():
            if i.tag=='field':
                if values.has_key(i.attrib['name']):
                    values[i.attrib['name']]=i.attrib['value']
            else:
                print "Warning: unknown tag " + i.tag

        self.escape_values_dict(values)

        return values

    def regenerate_field_params(self,values_dict):
        d=jaxml.XML_Document()
        for k,v in values_dict.iteritems():
            d._push()
            d.field(name=k,value=v)
            d._pop()
        return d

    def generate_insert_query(self,table,values):

        q = "INSERT INTO " + table + " ("
        for i in values.iterkeys():
            q+=i + ','    
        q=q[:-1]+') VALUES ('

        for i in values.itervalues():
            q+="'" + i + "'" + ","

        q=q[:-1]+')'

        return q


    def generate_update_query(self,table,values,where_clauses):

        q = "UPDATE " + table + " SET "
        for k,v in values.iteritems():
            q+= k + '=' + "'" + v + "',"

        q=q[:-1]+" WHERE ("

        if isinstance (where_clauses,str):
            q+=where_clauses
        else:
            for i in where_clauses:
                q+=i[0] + i[1] + "'" + i[2] + "' AND "
            q=q[:-len(" AND ")]

        q+=")"
        
        return q


    def escape_value(self,val):
        return str(val).replace("'","\\'"
                           ).replace("(","\\("
                                     ).replace(")","\\)"
                                               ).replace('"','\\"')
    def escape_name(self,val):
        x=""
        i=False
        for t in val:
            if t in 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_':
                x+=t
                i=True
                continue
            if i and (t in '0123456789') :
                x+=t            
        return x

    def escape_values_list(self,values):
        for i,v in enumerate(values):
            values[i]=self.escape_value(v)

    def escape_values_dict(self,values):
        for k,v in values.iteritems():
            l=self.escape_name(k)
            u=self.escape_value(v)
            if l != k:
                del values[k]

            values[l]=u

    def oggi(self):
        
        x=datetime.date.today()
        return str(x)

    def getiso(self,val):
        t=datetime.date.today()
        val = str(val).split(' ')[0]

        if str(val)=='None' or str(val)=='':
            return t.year,t.month,t.day
        else: 
            x=val.split('-')
            if len(x)!=3:             
                x=val.split('/')
                if len(x)!=3:
                    x=[t.year,t.month,t.day]
            
            if len(str(x[2]))==4:
                t= int(x[2]),int(x[1]),int(x[0])
            else: # iso format
                t= int(x[0]),int(x[1]),int(x[2])
            
            return min(t[0],9999),min(t[1],11),min(t[2],31)

    def italian_date(self,datestring):
        x=self.getiso(datestring)
        return "%02i/%02i/%s"%(int(x[2]),int(x[1]),x[0])

    def generate_create_table(self,name,fields):
        q="CREATE TABLE " + name + "(\n"

        qtail=""
        
        for g in fields:            
            f=field(**g)
            
            if f.pkey:
                qtail+="PRIMARY KEY (%s),\n"%f.name
            if f.fkey is not None:
                qtail+="FOREIGN KEY (%s) REFERENCES %s,\n"%(f.name,f.fkey)
            if f.check is not None:
                qtail+="CHECK (%s),\n"%f.check
            
            typ='text' # text implica maxlen=0
            if f.type=='str' and f.maxlen>0:
                typ='VARCHAR(%i)' % f.maxlen
            elif f.type=='int':
                if f.autokey:
                    typ='SERIAL'
                else:
                    typ='INTEGER'
            elif f.type=='float':
                ## NUMERIC(precision,scale)
                typ='NUMERIC(%i,%i)'%(10+f.maxlen,f.maxlen)
            elif f.type=='bool':
                typ='boolean'
            
            q+="%-25s"%f.name +typ+",\n"
            
        m=q+qtail
        m=m[:-2]+"\n);\n\n" ## remove trailing ",\n", and close
        
        return m

    def gen_filter_cond(self,allowed_fields,fields):
        self.escape_values_dict(fields)
        l=[]
        for k,v in fields.iteritems():
            if k in allowed_fields:
                l.append("%s='%s'"%(k,v))

        return string.join(l," AND ")


    def fetch_config(self):
        c=self.db.cursor()
        q="SELECT * FROM config"
        c.execute(q)
        cfg={}
        x=c.dictfetchall()
        for a in x:
            cfg[a['nome']]=a['valore']
        return cfg

    def extractyear(self,n):
        return int(n)/1000000

    def extractn(self,n):
        return int(n)-self.extractyear(n)*1000000
