#! /usr/bin/python

# Copyright (C) 2005 Cristian Greggio

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


### modulo per gli ordini di acquisto
from module import *

class handler(module):
    def __init__(self,name,be):
        # richiama i moduli per l'ordine d'acquisto
        module.__init__(self,name,"Scarichimage",be)
        self.addhandler("list",self.list,menu="Vista Scarichi Magazino")
        self.addhandler("add",self.add)
        self.addhandler("add-db",self.add_db)
        self.addhandler("mod",self.mod)
        self.addhandler("mod-db",self.mod_db)
        self.addhandler("del",self.del_db)

#### parte della posizione degli ordini #####
        

        # crea la lista principale
    def list(self,d,e):
        a=e.attrib ## check also parameters like search or paging

        d._push()
        d.ui(type="listview")

        d._push()
        d.command(stock="add",action="scarichimage/add",update="true")
        d._pop()

        d._push()
        d.command(stock="delete",action="carichimage/del",forwardselection="id_movmage_c",update="true")
        d._pop()

        d._push()
        d.command(stock="edit",action="scarichimage/mod",forwardselection="id_movmage_s",update="true")
        d._pop()

        d._push()
        d.command(title="Giacenze",action="viste/list_giacenze",update="true")
        d._pop()


        d._pop()
        
        d._push()
        d.data(type="table")
        #headers
        d._push()
        d.headers()
        # definisce le caselle che si devono vedere type deve essere str
        d._push()
        d.header(name="id_movmage_s", title="Id", type="str")
        d._pop()
        
        d._push()
        d.header(name="magazino_s", title="Magazzino", type="str")
        d._pop()

        d._push()
        d.header(name="tipo_operazione_s", title="Tipo Operazione",type="str") #....
        d._pop()

        d._push()
        d.header(name="articolo_movmage_s", title="articolo", type="str")
        d._pop()

        d._push()
        d.header(name="q_ta_movmage_s", title="Quantita'", type="str")
        d._pop()


        d._pop() #headers

        d._push()
        d.rows()

        # definisce la tabella o la vista da dove leggere
        c=self.db.cursor()
        c.execute("SELECT * FROM scarico_magazino")
        #c.execute("SELECT * FROM posizioni_oda WHERE numero_oda='" + a['id_oda'] + "'")
        data = c.dictfetchall()
        for r in data:
            d._push()
            d.row(None,**r)
            d._pop()
        d._pop()

        d._pop()

        #at top level

    def add(self,d,e):
        a=e.attrib


        # definisce la vista add
        
        d._push()
        d.ui(type="amwindow")
        d._push()
        d.dialog(action="scarichimage/add-db", type="add")
        d._pop()

        d._push()
        d.title("Aggiungi Posizione a Ordine acquisto")
        d._pop()
        
        d._push()
        d.msg("Inserire i dati per aggiungere un nuova posizione ordine")
        d._push()
        
        d._push()
        d.field(name="articolo_movmage_s", title="Articolo",  type='str',
                           defvalue="",optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()

        
        d._push()
        d.field(name="magazino_s", title="Magazzino",  type='str',
                           defvalue="",optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()

        d._push()
        d.field(name="tipo_operazione_s", title="Tipo Operazione", type='str',
                           defvalue="scarico_vendita",optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()

        d._push()
        d.field(name="q_ta_movmage_s", title="Quantita'", type='str',
                           defvalue="",optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()

        d._push()
        d.field(name="prezzo_movmage_s", title="Prezzo", type='str',
                           defvalue="",optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()
        
        d._push()
        d.field(name="iva_mov_mage_s", title="Iva", type='int',
                           defvalue="",optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()
        

        d._push()
        d.field(name="data_movmage_s", title="data",  type='int',
                           defvalue="",optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()

        d._push()
        d.field(name="numero_ddt_s", title="Numero DDT",  type='int',
                           defvalue="",optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()

        d._push()
        d.field(name="numero_inv_s", title="Numero Fattura",  type='int',
                           defvalue="",optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()

        d._push()
        d.field(name="id_scheda_produzione_s", title="Numero Scheda Produzione",  type='int',
                           defvalue="",optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip',ref="produzione/list",refname="id_scheda_produzione")
        d._pop()

        d._pop() # ui
        
        d._push()
        d.data()
        d._pop()
        
        

        #at top level




    def mod(self,d,e):
        a=e.attrib 
        #print "item: ", ['item_pos_oda']
        c=self.db.cursor()
        c.execute("SELECT * FROM scarico_magazino WHERE id_movmage_s='" + a['id_movmage_s'] + "'")
        data = c.dictfetchone()

        if data is None: #bail out!!!
            raise Exception("Select call failed!!")
            

        d._push()
        d.ui(type="amwindow")
        d._push()
        d.dialog(action="scarichimage/mod-db", type="mod")
        d._pop()

        d._push()
        d.title("Modifica Posizione Ordine")
        d._pop()
        
        d._push()
        d.msg("Modifica Posizione Ordine")
        d._push()

        # inizio della scheda per l'immissione dei dati

        d._push()
        d.field(name="id_movmage_s", title="id",  type='str',
                           defvalue=data['id_movmage_s'],optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()

        d._push()
        d.field(name="articolo_movmage_s", title="Articolo",  type='str',
                           defvalue=data['articolo_movmage_s'],optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()

        
        d._push()
        d.field(name="magazino_s", title="Magazzino",  type='str',
                           defvalue=data['magazino_s'],optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()


        d._push()
        d.field(name="q_ta_movmage_s", title="Quantita'", type='str',
                           defvalue=data['q_ta_movmage_s'],optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()

        d._push()
        d.field(name="prezzo_movmage_s", title="Prezzo", type='str',
                           defvalue=data['prezzo_movmage_s'],optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()
        
        d._push()
        d.field(name="iva_mov_mage_s", title="Iva", type='int',
                           defvalue=data['iva_mov_mage_s'],optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()
        

        d._push()
        d.field(name="data_movmage_s", title="data",  type='int',
                           defvalue=data['data_movmage_s'],optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()

        d._push()
        d.field(name="numero_ddt_s", title="Numero DDT",  type='int',
                           defvalue=data['numero_ddt_s'],optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()

        d._push()
        d.field(name="numero_inv_s", title="Numero Fattura",  type='int',
                           defvalue=data['numero_inv_s'],optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()

        d._push()
        d.field(name="id_scheda_produzione_s", title="Numero Scheda Produzione",  type='int',
                           defvalue=data['id_scheda_produzione_s'],optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip',ref="produzione/list",refname="id_scheda_produzione")
        d._pop()

        d._pop() # ui
        
        
        d._push()
        d.data()
        d._pop()
        
        

        #at top level

    def add_db(self,d,e): # definisce cosa inserire
        a=e.attrib 

        valuesl=('articolo_movmage_s','magazino_s','tipo_operazione_s','q_ta_movmage_s','prezzo_movmage_s','iva_mov_mage_s', 'data_movmage_s','numero_ddt_s','numero_inv_s','id_scheda_produzione_s')
        values={}
        for i in valuesl:
            values[i]=''

        for i in e.getchildren():
            if i.tag=='field':
                if values.has_key(i.attrib['name']):
                    values[i.attrib['name']]=i.attrib['value']
            else:
                print "Warning: unknown tag " + i.tag

        print values
        c = self.db.cursor()

        q = "INSERT INTO scarico_magazino ("
        for i in values.iterkeys():
            q+=i + ','    
        q=q[:-1]+') VALUES ('
        
        for i in values.itervalues():
            q+="'" + i + "'" + ","

        q=q[:-1]+')'
        print "scarichi_mage/add-db: query: " + q

        
        c.execute (q)
        self.db.commit()
        
        d._push()
        d.ui(type="message")
        d._pop()

        d._push()
        d.data("Operazione eseguita",type="text")
        d._pop()

        #at top level

    def mod_db(self,d,e): # definisce cosa modificare

        a=e.attrib
        # queste e' la lista dei malori da modificare
        valuesl=('id_movmage_s','articolo_movmage_s','magazino_s','q_ta_movmage_s','prezzo_movmage_s','iva_mov_mage_s', 'data_movmage_s','numero_ddt_s','numero_inv_s','id_scheda_produzione_s')        
        values={}
        for i in valuesl:
            values[i]=''

        for i in e.getchildren():
            if i.tag=='field':
                if values.has_key(i.attrib['name']):
                    values[i.attrib['name']]=i.attrib['value']
            else:
                print "Warning: unknown tag " + i.tag

        print values
        c = self.db.cursor()

        q = "UPDATE scarico_magazino SET "
        for k,v in values.iteritems():
            q+= k + '=' + "'" + v + "',"
        
        q=q[:-1]+" WHERE id_movmage_s ='" + values['id_movmage_s'] + "'"
        
        print "pos_oda/mod-db: query: " + q

        
        c.execute (q)
        self.db.commit()
        
        d._push()
        d.ui(type="message")
        d._pop()

        d._push()
        d.data("Operazione eseguita",type="text")
        d._pop()


    def del_db(self,d,e): #definisce cosa cancellare
        a=e.attrib 
        c = self.db.cursor()
        q="DELETE FROM carico_magazino WHERE id_movmage_c='" +a['id_movmage_c'] + "'"
        c.execute (q)
        self.db.commit()
        
        print "utenti/del: query: " + q

        d._push()
        d.ui(type="message")
        d._pop()

        d._push()
        d.data("Operazione eseguita",type="text")
        d._pop()

        #at top level

    def sel_ordinato(self,d,e):
        a=e.attrib ## check also parameters like search or paging
        d._push()
        d.ui(type="listview")
        # definisce i comandi e cosa devono fare

        d._push()
        #d.command(stock="add",action="pos_oda/add",update="true")
        d.command(stock="add",action="carichimage/add_pos_oda", forwardselection="id_pos", update="true")
        d._pop()

        d._pop()
        
        d._push()
        d.data(type="table")
        #headers
        d._push()
        d.headers()
        # definisce le caselle che si devono vedere type deve essere str
        d._push()
        d.header(name="id_pos", title="id", type="str")
        d._pop()


        d._push()
        d.header(name="id_oda", title="Numero Ordine", type="str")
        d._pop()

        d._push()
        d.header(name="item_pos_oda", title="Numero Pos.",type="str") #....
        d._pop()

        d._push()
        d.header(name="codice_fornitore", title="codice fornitore", type="str")
        d._pop()

        d._push()
        d.header(name="articolo", title="articolo", type="str")
        d._pop()

        d._push()
        d.header(name="quantita", title="quantita'", type="str")
        d._pop()

        d._push()
        d.header(name="prezzo", title="prezzo", type="str")
        d._pop()

        d._push()
        d.header(name="sconto", title="sconto", type="str")
        d._pop()

        d._push()
        d.header(name="iva", title="IVA", type="str")
        d._pop()

        d._pop() #headers

        d._push()
        d.rows()

                # definisce la tabella o la vista da dove leggere
        c=self.db.cursor()

        c.execute("SELECT * FROM vis_oda_pos")
        #print query
        #c.execute(query)

        data = c.dictfetchall()
        for r in data:
            d._push()
            d.row(None,**r)
            #d.row(r)
            d._pop()
        d._pop()

        d._pop()
    

