#! /usr/bin/python

# Copyright (C) 2005 Aldo Nicolas Bruno

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


### modulo di esempio....
from module import *

class handler(module):
    def __init__(self,name,db):
        module.__init__(self,name,"Schede Produzione",db)
        self.addhandler("list",self.list,"Produzione/Schede/Aggiungi")
        self.addhandler("add",self.add)
        self.addhandler("add-db",self.add_db)
        self.addhandler("mod",self.mod)
        self.addhandler("mod-db",self.mod_db)
        self.addhandler("del",self.del_db)

    def list(self,d,e):
        a=e.attrib ## check also parameters like search or paging

        d._push()
        d.ui(type="listview")

        d._push()
        d.command(stock="add",action="produzione/add",update="true")
        d._pop()
        d._push()
        d.command(stock="delete",action="produzione/del",forwardselection="id_scheda_produzione",update="true")
        d._pop()
        d._push()
        d.command(stock="edit",action="produzione/mod",forwardselection="id_scheda_produzione",update="true")
        d._pop()

        d._pop()
        
        d._push()
        d.data(type="table")
        #headers
        d._push()
        d.headers()

        d._push()
        d.header(name="id_scheda_produzione", title="N. Scheda",type="str") #....
        d._pop()

        d._push()
        d.header(name="data_scheda_produzione", title="Data Scheda Produzione", type="str")
        d._pop()

        d._pop() #headers

        d._push()
        d.rows()
        c=self.db.cursor()
        c.execute("SELECT * FROM scheda_produzione")
        data = c.dictfetchall()
        for r in data:
            d._push()
            d.row(None,**r)
            d._pop()
        d._pop()

        d._pop()

        #at top level

    def add(self,d,e):
        a=e.attrib 

        
        d._push()
        d.ui(type="amwindow")
        d._push()
        d.dialog(action="produzione/add-db", type="add")
        d._pop()

        d._push()
        d.title("Aggiungi Scheda Produzione")
        d._pop()
        
        d._push()
        d.msg("Inserire i dati per aggiungere un nuovo utente")
        d._push()
        
        
        d._push()
        d.field(name="data_scheda_produzione", title="Data Produzione",  type='str',
                           defvalue="",optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()

        d._push()
        d.field(name="note_scheda_pro", title="Note",  type='str',
                           defvalue="",optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()
        
        d._pop() # ui
        
        d._push()
        d.data()
        d._pop()
        
        

        #at top level



    def mod(self,d,e):
        a=e.attrib 

        c=self.db.cursor()
        c.execute("SELECT * FROM scheda_produzione WHERE id_scheda_produzione='" + a['id_scheda_produzione'] + "'")
        data = c.dictfetchone()

        if data is None: #bail out!!!
            raise Exception("Select call failed!!")
            

        d._push()
        d.ui(type="amwindow")
        d._push()
        d.dialog(action="produzione/mod-db", type="mod")
        d._pop()

        d._push()
        d.title("Modifica utente")
        d._pop()
        
        d._push()
        d.msg("Modifica i dati dell'utente utente")
        d._push()
        
        d._push()
        d.field(name="id_scheda_produzione", title="ID", type='str',
                           defvalue=data['id_scheda_produzione'],optional=False, readonly=True,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()
        
        d._push()
        d.field(name="data_scheda_produzione", title="Password",  type='str',
                           defvalue=data['data_scheda_produzione'],optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()

        d._push()
        d.field(name="note_scheda_pro", title="Note",  type='str',
                           defvalue=data['note_scheda_pro'],optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()
        
        d._pop() # ui
        
        d._push()
        d.data()
        d._pop()
        
        

        #at top level

    def add_db(self,d,e):
        a=e.attrib 

        valuesl=('data_scheda_produzione','note_scheda_pro')
        values={}
        for i in valuesl:
            values[i]=''

        for i in e.getchildren():
            if i.tag=='field':
                if values.has_key(i.attrib['name']):
                    values[i.attrib['name']]=i.attrib['value']
            else:
                print "Warning: unknown tag " + i.tag

        print values
        c = self.db.cursor()

        q = "INSERT INTO  scheda_produzione ("
        for i in values.iterkeys():
            q+=i + ','    
        q=q[:-1]+') VALUES ('
        
        for i in values.itervalues():
            q+="'" + i + "'" + ","

        q=q[:-1]+')'

#        q = "INSERT INTO scheda_produzione VALUES ('data_scheda_produzione'='"+a['data_scheda_produzione']+"')"
        print "utenti/add-db: query: " + q

        
        c.execute (q)
        self.db.commit()
        
        d._push()
        d.ui(type="message")
        d._pop()

        d._push()
        d.data("Operazione eseguita",type="text")
        d._pop()

        #at top level

    def mod_db(self,d,e):
        a=e.attrib 

        valuesl=('id_scheda_produzione','data_scheda_produzione','note_scheda_pro')

        values={}
        for i in valuesl:
            values[i]=''

        for i in e.getchildren():
            if i.tag=='field':
                if values.has_key(i.attrib['name']):
                    values[i.attrib['name']]=i.attrib['value']
            else:
                print "Warning: unknown tag " + i.tag

        print values
        c = self.db.cursor()

        q = "UPDATE scheda_produzione SET "
        for k,v in values.iteritems():
            q+= k + '=' + "'" + v + "',"
        
        q=q[:-1]+" WHERE id_scheda_produzione ='" + values['id_scheda_produzione'] + "'"
        
        print "utenti/mod-db: query: " + q

        
        c.execute (q)
        self.db.commit()
        
        d._push()
        d.ui(type="message")
        d._pop()

        d._push()
        d.data("Operazione eseguita",type="text")
        d._pop()


    def del_db(self,d,e):
        a=e.attrib 

        c = self.db.cursor()
        q="DELETE FROM scheda_produzione WHERE id_scheda_produzione='" +a['id_scheda_produzione'] + "'"
        c.execute (q)
        self.db.commit()
        
        print "produzione/del: query: " + q

        d._push()
        d.ui(type="message")
        d._pop()

        d._push()
        d.data("Operazione eseguita",type="text")
        d._pop()

        #at top level

    


    

