#! /usr/bin/python

# Copyright (C) 2005 Cristian Greggio
# Copyright (C) 2006 Aldo Nicolas Bruno

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import os
from module import *


class handler(module):
    def __init__(self,name,be):
        module.__init__(self,name,"Ordini Acquisto",be) # serve a identificare il nome mod

        self.gen()
        
        #self.addhandler("add",self.addmod,menu="Aggiungi")
        #self.addhandler("add-db",self.add_db)

        self.addhandler("del",self.del_db)

#        self.addhandler("prova",self.prova)
        
#    def prova(self,d,e):
#        a=e.attrib
#        print a
    
        
    def field_gen(self,x):
        ##name,title,type,defvalue,maxlen,optional,password,help,multiline,tooltip,ref,refname,refattrib
    ##attenzione il primo elemento verra usato come riferimento fisso x la modifica
        x.addfield("id_oda","Id Oda","str","",0,
                   True,None,"",False,"xx")
        x.addfield("data_oda","Data Ordine","str",self.be['dbutil'].oggi(),0,
                   False,None,"",False,"xx")
        x.addfield("codice_forn_oda","Codice Fornitore","str","",15,
                   False,None,"",False,"xx","fornitori/list","codice_fornitore")

    def field_gen_ex(self,x):
        x.addfield("note_oda","note_oda","str"," ",0,
                   True,None,"",True,"Descrizione testuale")    
    
    def gen(self):
        #aggiungi
        x=self.be['uiutil'].adddialog("Aggiungi","Inserire i dati per aggiungere un nuovo Articolo","oda/add-db")

        self.field_gen(x)
        self.field_gen_ex(x)
        
        self.addhandler("add",x.handle,"Acquisto/Ordini/Aggiungi")
        self.addhandler("add-db",self.add_db)

        # modifica
        x=self.be['uiutil'].moddialog("Modifica", "Modifica di un articolo","oda/mod-db",self.mod_sel)
        
        self.field_gen(x)
        self.field_gen_ex(x)
        self.addhandler("mod",x.handle,"Acquisto/Ordini/Modifica")
        self.addhandler("mod-db",self.mod_db)

        # listino
        x=self.be['uiutil'].listdialog("Lista Ordini Acquisto","Lista Ordini Acquisto", self.list_sel)

        self.field_gen(x)
        
        x.addcommand("oda/add","Aggiungi","add",update="true")
        x.addcommand("oda/mod","Modifica","edit",fwsel="id_oda",update="true",doubleclick="true")
        x.addcommand("oda/del","Rimuovi","delete",fwsel="id_oda",update="true")
        #        x.addcommand("articoli/prova","Prova","prova",refattrib={'a':'pippo'})
        x.addcommand("articoli/report","Report","report")
        self.addhandler("report",self.report)
        
        self.addhandler("list",x.handle,"Acquisto/Ordini/Listino")
        
    def list_sel(self,d,e):
        a=e.attrib ## check also parameters like search or paging

        c=self.db.cursor()
        if a.has_key("id_oda"):
            c.execute("SELECT * FROM oda WHERE id_oda='" + self.be['dbutil'].escape_value(a['id_oda']) + "'")
        else:
            c.execute("SELECT * FROM oda")
        
        data = c.dictfetchall()
        return data
    

    def mod_sel(self,d,e):
        a=e.attrib 

        c=self.db.cursor()
        c.execute("SELECT * FROM oda WHERE id_oda='" + a['id_oda'] + "'")
        data = c.dictfetchone()
        
        if data is None: #bail out!!!
            raise Exception("Select call failed! Maybe the item does not exist")
        return data
    
    def add_db(self,d,e):
        a=e.attrib 
        # definisce quali campi si passa ad db
        valuesl=('data_oda','codice_forn_oda','note_oda')
        values=self.be['dbutil'].cleanup_field_params(e,valuesl)
        
        c = self.db.cursor()
        # definisce la tabella su cui inserire i dati
        q = self.be['dbutil'].generate_insert_query("oda",values)
        
        print "oda/add-db: query: " + q
        
        c.execute (q)
        self.db.commit()
        
        d._push()
        d.ui(type="message")
        d._pop()

        d._push()
        d.data("Operazione eseguita",type="text")
        d._pop()

        #at top level

    def mod_db(self,d,e):
        a=e.attrib 
        # definisce quali campi si passa ad db

        valuesl=('id_oda','data_oda','codice_forn_oda','note_oda')

        
        values=self.be['dbutil'].cleanup_field_params(e,valuesl)
        
        c = self.db.cursor()
        # definisce la tabella su cui aggiornare i dati
        q = self.be['dbutil'].generate_update_query("oda",values,[("id_oda","=",values['id_oda'])])
        
        print "oda/mod-db: query: " + q

        
        c.execute (q)
        self.db.commit()
        
        d._push()
        d.ui(type="message")
        d._pop()

        d._push()
        d.data("Operazione eseguita",type="text")
        d._pop()


    def del_db(self,d,e):
        a=e.attrib 

        c = self.db.cursor()
        
        c.execute ("DELETE FROM oda WHERE id_oda='" +a['id_oda'] + "'")
        self.db.commit()
        
        print "oda/del: query: "

        d._push()
        d.ui(type="message")
        d._pop()

        d._push()
        d.data("Operazione eseguita",type="text")
        d._pop()

        #at top level

    def report(self,d,e):
        c=self.db.cursor()
        
        from freereport import *
        ##FIXME We should not use tempnam()
        name=os.tempnam()

        doc=freereport_pdf(a4,name)
        doc.setsize(*a4)
        t=doc.table()
        doc.additem(doc.paragraph("Prova di report sql con la magnifica FREEREPORT by aldox86"))
        t.addrow_txt(["codice","descrizione","um","tipo","prezzo std"])
        
        t.add_from_sql(c,"SELECT codice,descrizione,um,tipo,prezzo_std FROM articoli")
        
        doc.additem(t)

        doc.generate()
        
        d._push()
        d.ui(type="print")
        d._pop()
        
        from binascii import b2a_base64
        d._push()

        d.data("<![CDATA["+b2a_base64(file(name,"rb").read())+"]]>",format="pdf")
        d._pop()
        
        d._push()
        d.ui(type="print")
        d._pop()


        print 
        
