
#! /usr/bin/python

# Copyright (C) 2006 Aldo Nicolas Bruno

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import os
from module import *

from util.ui import simpledbmodule

class handler(simpledbmodule):
    def __init__(self,name,be,version=0.1):

    ##attenzione il primo elemento verra usato come riferimento fisso x la modifica
        fields=[
            {'name':'id_fase_odp',
             'title':'ID',
             'type':'int',
             'defvalue':"",
             'maxlen':15,
             'optional':False,
             'tooltip':'ID',
             'autokey':True,
             },
            {'name':'n_odp',
             'title':'N. Ordine Produzione',
             'type':'str',
             'defvalue':'',
             'maxlen':0,
             'optional':False,
             'tooltip':'',
             'ref':'odp/list',
             'refname':'n',
             'fkey':'opd(id_odp)',
             'readonly':True,
             'fwvalue':'id_odp'
             },
            {'name':'data_inizio',
             'title':'Data Inizio',
             'type':'date',
             'defvalue':be['dbutil'].oggi(),
             'maxlen':0,
             'optional':False,
             'tooltip':'Data Inizio'
             },
            {'name':'data_fine',
             'title':'Data Fine',
             'type':'date',
             'defvalue':be['dbutil'].oggi(),
             'maxlen':0,
             'optional':False,
             'tooltip':'Data Fine'
             },
            {'name':'descr_fase_odp',
             'title':'Descrizione Fase',
             'type':'str',
             'defvalue':"",
             'maxlen':15,
             'optional':False,
             'tooltip':'',
             'readonly':False,
             },
            {'name':'bloccato',
             'title':'Bloccato',
             'type':'bool',
             'defvalue':"False",
             'maxlen':0,
             'tooltip':'Bloccato'
             },
            {'name':'note_fase_odp',
             'title':'Note aggiuntive',
             'type':'str',
             'defvalue':"",
             'maxlen':0,
             'optional':True,
             'multiline':True,
             'tooltip':'Note aggiuntive'
             }
            ]
        
        simpledbmodule.__init__(self,name,"POS ODP",be,fields,None,table="fase_odp",menu="")

    def list_sel(self,d,e):
        c=self.db.cursor()
        val=self.be['dbutil'].escape_value(e.attrib['id_odp'])
        
        c.execute("SELECT * FROM fase_odp WHERE bloccato='f'n_odp='%s'" % val)
        
        data = c.dictfetchall()
    
        return data

    def gen_commands(self,x):
        simpledbmodule.gen_commands(self,x)
        x.addcommand("carichipro/list","Gestisci Carico Pro",None,fwsel=self.key,update="true")
        x.addcommand("scarichipro/list","Gestisci Scarico Pro",None,fwsel=self.key,update="true")
