
#! /usr/bin/python

# Copyright (C) 2006 Aldo Nicolas Bruno

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import os
from module import *

from util.ui import simpledbmodule

class handler(simpledbmodule):
    def __init__(self,name,be,version=0.1):

    ##attenzione il primo elemento verra usato come riferimento fisso x la modifica
        fields=[
            {'name':'id_movimento',
             'title':'ID',
             'type':'int',
             'defvalue':"",
             'maxlen':15,
             'optional':False,
             'tooltip':'ID',
             'autokey':True,
             },
            {'name':'fase_odp_carico',
             'title':'ID Fase ODP',
             'type':'int',
             'defvalue':'',
             'maxlen':0,
             'optional':False,
             'tooltip':'',
             'ref':'faseodp/list',
             'refname':'id_fase_odp',
             'fkey':'faseodp(id_fase_odp)',
             'readonly':True,
             'fwvalue':'id_fase_odp'
             },
            {'name':'data_movimento',
             'title':'Data',
             'type':'date',
             'defvalue':be['dbutil'].oggi(),
             'maxlen':0,
             'optional':False,
             'tooltip':'Data DDT'
             },
            {'name':'codice_mov_mage',
             'title':'Tipo Movimento',
             'type':'str',
             'defvalue':"pr_ca",
             'maxlen':15,
             'optional':False,
             'tooltip':'',
             'readonly':True,
             },
            {'name':'codice_magazzino',
             'title':'Articolo',
             'type':'str',
             'defvalue':"",
             'maxlen':15,
             'optional':False,
             'tooltip':'',
             'ref':'articoli/list',
             'refname':'codice',
             'fkey':'articoli(codice)',
             },
            {'name':'prev_qta_carico_pro',
             'title':'Quantita Prevista',
             'type':'float',
             'defvalue':"1",
             'maxlen':3,
             'optional':False,
             'tooltip':''
             },
            {'name':'qta_carico',
             'title':'Quantita Effettiva',
             'type':'float',
             'defvalue':"0",
             'maxlen':3,
             'optional':False,
             'tooltip':''
             },
            {'name':'note_magazzino',
             'title':'Note aggiuntive',
             'type':'str',
             'defvalue':"",
             'maxlen':0,
             'optional':True,
             'multiline':True,
             'tooltip':'Note aggiuntive'
             }
            ]
        
        simpledbmodule.__init__(self,name,"Carico da Produzione",be,fields,delete=False,table="magazzino",menu="")

    def list_sel(self,d,e):
        c=self.db.cursor()
        val=self.be['dbutil'].escape_value(e.attrib['id_fase_odp'])
        
        c.execute("SELECT * FROM magazzino WHERE fase_odp_carico='%s'" % val)
        
        data = c.dictfetchall()
    
        return data
