#! /usr/bin/python
# -*- coding: iso-8859-1 -*-
# Copyright (C) 2006 Aldo Nicolas Bruno

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import os
from module import *

from util.ui import simpledbmodule

class handler(simpledbmodule):
    def __init__(self,name,be,version=0.1):

    ##attenzione il primo elemento verra usato come riferimento fisso x la modifica
        fields=[
            {'name':'n_prev_ven',
             'title':'Numero',
             'type':'int',
             'defvalue':"",
             'maxlen':15,
             'optional':False,
             'tooltip':'Numero progressivo',
             'autokey':True
             },
            {'name':'cliente_prev_ven',
             'title':'Cliente',
             'type':'str',
             'defvalue':"",
             'maxlen':15,
             'optional':False,
             'tooltip':'Cliente',
             'ref':'persone/clienti',
             'refname':'codice,nome',
             'reftype':'combo',
             'fkey':'persone(codice)'
             },
            {'name':'data_prev_ven',
             'title':'Data',
             'type':'date',
             'defvalue':be['dbutil'].oggi(),
             'maxlen':0,
             'optional':False,
             'tooltip':'Data Preventivo'
             },
            {'name':'scadenza_prev',
             'title':'Data Scadenza',
             'type':'date',
             'defvalue':be['dbutil'].oggi(),
             'maxlen':0,
             'optional':False,
             'tooltip':'Data Scadenza Preventivo'
             },
            {'name':'sconto_prev_ven',
             'title':'Sconto',
             'type':'float',
             'defvalue':0,
             'maxlen':3,
             'optional':False,
             'tooltip':'Sconto Preventivo'
             },
            
            {'name':'confermato',
             'title':'Confermato',
             'type':'bool',
             'defvalue':"False",
             'maxlen':0,
             'tooltip':'Confermato',
             'readonly':True
             },
            {'name':'note_prev_ven',
             'title':'Note aggiuntive',
             'type':'str',
             'defvalue':"",
             'maxlen':0,
             'optional':True,
             'multiline':True,
             'tooltip':'Note aggiuntive'
             }
            ]
        
        simpledbmodule.__init__(self,name,"Preventivi Vendita",be,fields,table="preventivi_ven",menu="Vendite/Preventivi")

        ## richiamiamo il controllo per la form modifica in solo lettura
        self.mod_dialog.readonlycb=self.readonlycb
        self.addhandler("conferma",self.conferma_db)
        self.addhandler("stampa",self.stampa)

    def readonlycb(self,d,e):
        a=e.attrib
        c=self.db.cursor()
        val=self.be['dbutil'].escape_value(a[self.key])
        c.execute("SELECT confermato FROM preventivi_ven WHERE n_prev_ven='%s'" % val)
        x=c.fetchone()

        return x[0] in ('t',True,'true','1','TRUE','True')
    
    ## vediamo solo i preventivi che non sono bloccati
    def list_sel(self,d,e):
        c=self.db.cursor()
            
        c.execute("SELECT * FROM preventivi_ven \
                   ORDER BY n_prev_ven")
        
        data = c.dictfetchall()
    
        return data

    def conferma_db(self,d,e):
        n=self.be['dbutil'].escape_value(e.attrib['n_prev_ven'])

        c=self.db.cursor()

        if self.readonlycb(d,e):
            raise SoftException("ERRORE! Il preventivo e' gia' stato confermato.")

        c.execute ("SELECT * from magazzino WHERE preventivo='%s'"%n)
        ddt_pos=c.fetchall()
        
        if len(ddt_pos) ==0:
            raise SoftException("Errore: Il preventivo non puo' essere vuoto!")

        c.execute("BEGIN")
        c.execute("UPDATE preventivi_ven set confermato='true' WHERE n_prev_ven='%s'"%n)
        c.execute("COMMIT")

        d._push()
        d.ui(type="message")
        d._pop()
        
        msg="Preventivo #%s confermato." %n
        
        d._push()
        d.data(msg,type="text")
        d._pop()        

    def gen_commands(self,x):
        simpledbmodule.gen_commands(self,x)
        x.addcommand("prev_poss/list","Gestisci posizioni",None,fwsel=self.key,update="true")
#        x.addcommand("pre2ddt/list","Spedisci posizioni",None,fwsel=self.key,update="true")
        x.addcommand(self.name+"/conferma","Conferma",None,fwsel=self.key,update="true",confirm="Sicuro di voler confermare il Preventivo? Nessuna modifica ulteriore verra' consentita")
        x.addcommand(self.name+"/stampa","Stampa",None,fwsel=self.key)
        

    def add_db_complete(self,d,e,values):
        simpledbmodule.add_db_complete(self,d,e,values)
        d._push()
        d.redirect(action="prev_poss/list").attrib(n_prev_ven=values['n_prev_ven'])
        d._pop()


    def stampa(self,d,e):
        n=self.be['dbutil'].escape_value(e.attrib['n_prev_ven'])

        if not self.readonlycb(d,e):
            raise SoftException ("Errore! il preventivo non e' confermato!")

        q="SELECT * FROM preventivi_ven WHERE n_prev_ven='%s'" % n

        c=self.db.cursor()
        c.execute(q)
        dati_fatt=c.dictfetchone()
        
        c.execute("SELECT * from preventivi_ven_view WHERE n_prev_ven='%s'" % n)
        totali_fatt=c.dictfetchone()
        
        q="""SELECT codice, articoli.descrizione, qta_prev_ven as qta,  \
        prezzo_vendita as prezzo, sconto_vendita as sconto,   \
        aliquota as iva, um,                                  \
        (prezzo_vendita*(1-sconto_vendita/100)*qta_prev_ven) as importo \
        FROM magazzino,articoli,codici_iva                    \
        WHERE codice_iva='20'                                 \
        AND codice_magazzino=codice                           \
        AND preventivo='%s'""" % n
        
        c.execute(q)
        fatt_pos = c.dictfetchall()
        
        if len(fatt_pos) ==0:
            raise SoftException("Errore: La fattura non puo' essere vuota! Errore fatale inconsistenza nel DB! Contattare l'amministratore del sistema")
        
        l=['prezzo','sconto','importo']
        for i,u in enumerate(fatt_pos):
            for k in l:
                fatt_pos[i][k]="%.2f"%fatt_pos[i][k]
            
        q="SELECT * FROM clienti WHERE codice='%s'"%dati_fatt['cliente_prev_ven']
        c.execute(q)
        dati_cli=c.dictfetchone()

        dati_azienda=self.be['dbutil'].fetch_config()
        
        n="%04i"%(int(n))
        
        f={'tipo':'PREVENTIVO',
           'n':n,
           'codcliente':dati_fatt['cliente_prev_ven'],
           'cliente':dati_cli['nome'],
           'indcliente':dati_cli['indirizzo'],
           'cittacliente':dati_cli['citta'],
           'notecliente':dati_cli['note'],
           'pivacliente':dati_cli['pi'],
           'data':self.be['dbutil'].italian_date(dati_fatt['data_prev_ven']),
           'abcde1231': ('limits','row',fatt_pos),
           'imponibile':"%.2f"%totali_fatt['imponibile'],
           'totale_iva':"%.2f"%totali_fatt['iva'],
           'totale':"%.2f"%totali_fatt['totale'],
           'sconto_fattura':"%.2f"%totali_fatt['sconto_prev_ven'],
           
           'azienda': dati_azienda['nome_azienda'],
           'piva':dati_azienda['piva_azienda'],
           'citta':dati_azienda['citta_azienda'],
           'indirizzo':dati_azienda['indirizzo_azienda'],
           'tel':dati_azienda['tel_azienda'],
           'fax':dati_azienda['fax_azienda'],
           'logo':dati_azienda['logo_azienda'],
           'note1':dati_fatt['note_prev_ven'],
           'note2':'',
           'note3':'',
           'note4':''
           }
        
        x=self.be['svg'].renderpdf("preventivo.svg",f)
       
        d._push()
        d.ui(type="print")
        d._pop()
        
        from binascii import b2a_base64
        d._push()
        
        d.data("<![CDATA["+b2a_base64(x)+"]]>",format="pdf")
        d._pop()
