#! /usr/bin/python

# Copyright (C) 2006 Cristian Greggio

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import os
from module import *

from util.ui import simpledbmodule

class handler(simpledbmodule):
    def __init__(self,name,be,version=0.1):

    ##attenzione il primo elemento verra usato come riferimento fisso x la modifica
        fields=[
            {'name':'id_movimento',
             'title':'ID',
             'type':'int',
             'defvalue':"",
             'maxlen':15,
             'optional':False,
             'tooltip':'ID',
             'autokey':True,
             'fwvalue':'n'
             },
            {'name':'preventivo',
             'title':'N. Preventivo',
             'type':'int',
             'defvalue':'',
             'maxlen':0,
             'optional':False,
             'tooltip':'',
             'ref':'preventivi/list',
             'refname':'n_prev_ven',
             'readonly':True,
             'fwvalue':'n_prev_ven'
             },
            {'name':'data_movimento',
             'title':'Data Consegna',
             'type':'date',
             'defvalue':be['dbutil'].oggi(),
             'maxlen':0,
             'optional':False,
             'tooltip':'Data Prevista Consegna'
             },
            {'name':'codice_mov_mage',
             'title':'Tipo Movimento',
             'type':'str',
             'defvalue':"ven",
             'maxlen':15,
             'optional':False,
             'tooltip':'',
             'readonly':True,
             },
            {'name':'codice_magazzino',
             'title':'Articolo',
             'type':'str',
             'defvalue':"",
             'maxlen':15,
             'optional':False,
             'tooltip':'',
             'ref':'articoli/list',
             'refname':'codice,descrizione',
             'reftype':'combo',
             'refupdate':'prezzo_vendita:prezzo_std',
             'fkey':'articoli(codice)',
             },
            {'name':'qta_prev_ven',
             'title':'Quantita da Preventivo',
             'type':'float',
             'defvalue':"1",
             'maxlen':3,
             'optional':False,
             'tooltip':''
             },
            {'name':'prezzo_vendita',
             'title':'Prezzo Vendita',
             'type':'float',
             'defvalue':"0",
             'maxlen':3,
             'optional':False,
             'tooltip':''
             },
            {'name':'sconto_vendita',
             'title':'Sconto',
             'type':'float',
             'defvalue':"0",
             'maxlen':3,
             'optional':False,
             'tooltip':''
             },
            {'name':'codice_iva_atv',
             'title':'Codice Iva',
             'type':'str',
             'defvalue':"20",
             'maxlen':5,
             'optional':False,
             'readonly':True,
             'ref':'viste/list_aliq_iva',
             'refname':'codice_iva,descrizione',
             'reftype':'combo',
             'tooltip':''
             },
            {'name':'note_magazzino',
             'title':'Note aggiuntive',
             'type':'str',
             'defvalue':"",
             'maxlen':0,
             'optional':True,
             'multiline':True,
             'tooltip':'Note aggiuntive'
             }
            ]
        
        simpledbmodule.__init__(self,name,"POS Preventivi",be,fields,delete=False,table="magazzino",menu="",sort="id_movimento")

        ## richiamiamo il controllo per la form modifica in solo lettura
        self.mod_dialog.readonlycb=self.confermato
        self.add_dialog.handlehook=self.confermato
        
        c=self.list_dialog.getcommand(self.name+"/add")
        c.fwparam="n_prev_ven"
        c=self.list_dialog.getcommand(self.name+"/mod")
        c.fwparam="n_prev_ven"
        
    def confermato(self,d,e):
        if self.be['preventivi'].readonlycb(d,e):
            raise SoftException("Errore! Il preventivo e' gia' confermato!! Nessuna modifica consentita.")


    def list_sel(self,d,e):
        c=self.db.cursor()
        val=self.be['dbutil'].escape_value(e.attrib['n_prev_ven'])
        
        c.execute("SELECT * FROM magazzino WHERE preventivo='%s'" % val)
        
        data = c.dictfetchall()
    
        return data
