#! /usr/bin/python

# Copyright (C) 2006 Aldo Nicolas Bruno

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import os
from module import *
from util.ui import simpledbmodule

class handler(simpledbmodule):
    def __init__(self,name,be,version=0.1):

    ##Definizione dei campi
    ##attenzione il primo elemento verra usato come riferimento fisso x la modifica
        fields=[
            {'name':'id_movimento',
             'title':'ID',
             'type':'int',
             'defvalue':"",
             'maxlen':15,
             'optional':False,
             'tooltip':'ID',
             'autokey':True,
             'fwvalue':'n'
             },
            {'name':'ddt_vendita',
             'title':'Numero di DDT',
             'type':'int',
             'defvalue':'',
             'maxlen':0,
             'optional':False,
             'tooltip':'',
             'ref':'ddtnoconf/list',
             'refname':'n',
             'readonly':False,
             },
            {'name':'preventivo',
             'title':'N. Preventivo',
             'type':'int',
             'defvalue':'',
             'maxlen':0,
             'optional':False,
             'tooltip':'',
             'readonly':True,
             },
            {'name':'data_movimento',
             'title':'Data Consegna',
             'type':'date',
             'defvalue':be['dbutil'].oggi(),
             'maxlen':0,
             'optional':False,
             'tooltip':'Data Prevista Consegna'
             },
            {'name':'codice_mov_mage',
             'title':'Tipo Movimento',
             'type':'str',
             'defvalue':"ven",
             'maxlen':15,
             'optional':False,
             'tooltip':'',
             'readonly':True,
             },
            {'name':'codice_magazzino',
             'title':'Articolo',
             'type':'str',
             'defvalue':"",
             'maxlen':15,
             'optional':False,
             'tooltip':'',
             'fkey':'articoli(codice)',
             'readonly':True,
             },
            {'name':'qta_prev_ven',
             'title':'Quantita\' da Preventivo',
             'type':'float',
             'defvalue':"1",
             'maxlen':3,
             'optional':False,
             'tooltip':'',
             'readonly':True,
             },
            {'name':'qta_scarico',
             'title':'Quantita\' Spedita',
             'type':'float',
             'defvalue':"0",
             'maxlen':3,
             'optional':False,
             'tooltip':'',
             'readonly':True,
             },
            {'name':'prezzo_vendita',
             'title':'Prezzo Vendita',
             'type':'float',
             'defvalue':"1",
             'maxlen':3,
             'optional':False,
             'tooltip':''
             },
            {'name':'sconto_vendita',
             'title':'Sconto',
             'type':'float',
             'defvalue':"1",
             'maxlen':3,
             'optional':False,
             'tooltip':''
             },
            {'name':'codice_iva_atv',
             'title':'Codice Iva',
             'type':'str',
             'defvalue':"20",
             'maxlen':5,
             'readonly':True,
             'optional':False,
             'ref':'viste/list_aliq_iva',
             'refname':'aliquota',
             'tooltip':''
             },
            {'name':'note_magazzino',
             'title':'Note aggiuntive',
             'type':'str',
             'defvalue':"",
             'maxlen':0,
             'optional':True,
             'multiline':True,
             'tooltip':'Note aggiuntive'
             }
            ]
        
        simpledbmodule.__init__(self,name,"Spedisci Riga Preventivi",be,fields,delete=False,table="magazzino",menu="")

        ## richiamiamo il controllo per la form modifica in solo lettura
        self.mod_dialog.readonlycb=self.readonlycb

    def readonlycb(self,d,e):
        ## effettua il controllo se la riga del preventivo è legata a una ddt
        ## non confermata e se vi sono non permette le modifiche
        a=e.attrib 
        c=self.db.cursor()
        val=self.be['dbutil'].escape_value(a[self.key])
        c.execute("SELECT preventivo, ddt_vendita, n, conf FROM magazzino, ddt WHERE ddt_vendita=n AND ddt.conf='f' AND preventivo='%s' " % val)
        risl=len(c.fetchall())
        ## se non ci sono righe permette la scrittura
        if risl == 0:
            return False
        else:
            return True

    def list_sel(self,d,e):
        c=self.db.cursor()
        val=self.be['dbutil'].escape_value(e.attrib['n_prev_ven'])
        
        c.execute("SELECT * FROM magazzino WHERE preventivo='%s' ORDER BY id_movimento" % val)
        
        data = c.dictfetchall()
    
        return data
