#! /usr/bin/python

# Copyright (C) 2005 Cristian Greggio
# Copyright (C) 2006 Aldo Nicolas Bruno

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


### modulo clienti

from module import *
from util.ui import simpledbmodule,simpleview

class handler(simpledbmodule):
    def __init__(self,name,be):
        fields=[
            {'name':'codice',
             'title':'Codice',
             'type':'str',
             'defvalue':"",
             'maxlen':15,
             'optional':False,
             'tooltip':'Esempio: PINCOSNC'
             },
            {'name':'nome',
             'title':'Nominativo',
             'type':'str',
             'defvalue':"",
             'maxlen':100,
             'optional':False,
             'tooltip':'Esempio: Pinco Pallino S.N.C.'
             },
            {'name':'indirizzo',
             'title':'Indirizzo',
             'type':'str',
             'defvalue':"",
             'maxlen':50,
             'optional':False,
             'tooltip':'Esempio: via Roma, 2'
             },
            {'name':'citta',
             'title':'Citta\'',
             'type':'str',
             'defvalue':"",
             'maxlen':100,
             'optional':False,
             'tooltip':''
             },
            {'name':'cap',
             'title':'CAP',
             'type':'int',
             'defvalue':"",
             'maxlen':'0',
             'optional':True,
             'tooltip':'Codice di avviamento postale'
             },
            {'name':'nazione',
             'title':'Nazione',
             'type':'str',
             'defvalue':"IT",
             'maxlen':2,
             'optional':False,
             'tooltip':'Codice nazione. Esempi: IT,GB,ES,FR'
             },
            {'name':'pi',
             'title':'P.IVA o C.F.',
             'type':'str',
             'defvalue':"",
             'maxlen':25,
             'optional':False,
             'tooltip':'Partita IVA o Codice Fiscale'
             },
            {'name':'tipo_pagamento',
             'title':'Tipo pagamento',
             'type':'str',
             'defvalue':"",
             'maxlen':60,
             'optional':False,
             'tooltip':''
             },
            {'name':'dilazione',
             'title':'Dilazione',
             'type':'int',
             'defvalue':"",
             'maxlen':0,
             'optional':False,
             'tooltip':'Ritardo pagamenti (es. 30 o 60 giorni)'
             },
            {'name':'banca',
             'title':'Banca',
             'type':'str',
             'defvalue':"",
             'maxlen':60,
             'optional':True,
             'tooltip':''
             },
            {'name':'cc',
             'title':'Conto Corrente',
             'type':'str',
             'defvalue':"",
             'maxlen':50,
             'optional':True,
             'tooltip':''
             },
            {'name':'iban',
             'title':'IBAN',
             'type':'str',
             'defvalue':"",
             'maxlen':60,
             'optional':True,
             'tooltip':''
             },
            
            {'name':'contatto',
             'title':'Contatto',
             'type':'str',
             'defvalue':"",
             'maxlen':30,
             'optional':True,
             'tooltip':'Nome contatto/riferimento'
             },
            {'name':'telefono',
             'title':'TEL',
             'type':'str',
             'defvalue':"",
             'maxlen':30,
             'optional':True,
             'tooltip':''
             },
            {'name':'fax',
             'title':'FAX',
             'type':'str',
             'defvalue':"",
             'maxlen':30,
             'optional':True,
             'tooltip':''
             },
            {'name':'email',
             'title':'E-Mail',
             'type':'str',
             'defvalue':"",
             'maxlen':50,
             'optional':True,
             'tooltip':''
             },
            {'name':'web',
             'title':'web',
             'type':'str',
             'defvalue':"",
             'maxlen':50,
             'optional':True,
             'tooltip':''
             },
            {'name':'f',
             'title':'Fornitore',
             'type':'bool',
             'defvalue':"True",
             'optional':True,
             'tooltip':''
             },
            {'name':'c',
             'title':'Cliente',
             'type':'bool',
             'defvalue':"True",
             'optional':True,
             'tooltip':''
             },
            {'name':'note',
             'title':'Note aggiuntive',
             'type':'str',
             'defvalue':"",
             'maxlen':0,
             'optional':True,
             'tooltip':''
             },            
            ]
        simpledbmodule.__init__(self,name,"Persone",be,fields,delete=True,table="persone",menu="Persone",sort='codice')

    def gen(self):
        self.be['uiutil'].simpleview(
            "Fornitori","Elenco fornitori",self,"fornitori",self.fields,
            "SELECT * FROM fornitori",menu="Persone/Fornitori")
        
        self.be['uiutil'].simpleview(
            "Clienti","Elenco clienti",self,"clienti",self.fields,
            "SELECT * FROM clienti",menu="Persone/Clienti")
        
    def generate_db(self):
        x=simpledbmodule.generate_db(self)

        x+="CREATE VIEW fornitori AS SELECT * from persone WHERE f=true;\n"
        x+="CREATE VIEW clienti   AS SELECT * from persone WHERE c=true;\n"
        return x
        
        
        
