
#! /usr/bin/python

# Copyright (C) 2006 Aldo Nicolas Bruno

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import os
from module import *

from util.ui import simpledbmodule

class handler(simpledbmodule):
    def __init__(self,name,be,version=0.1):

    ##attenzione il primo elemento verra usato come riferimento fisso x la modifica
        fields=[
            {'name':'id',
             'title':'Numero',
             'type':'int',
             'defvalue':"",
             'maxlen':15,
             'optional':False,
             'tooltip':'Numero progressivo',
             'autokey':True
             },
            {'name':'data_pag',
             'title':'Data',
             'type':'str',
             'defvalue':be['dbutil'].oggi(),
             'maxlen':0,
             'optional':False,
             'tooltip':'Data DDT'
             },
            {'name':'fattura_pag',
             'title':'Fattura',
             'type':'str',
             'defvalue':'',
             'maxlen':0,
             'optional':False,
             'tooltip':'Fattura Pagata',
             'ref':'viste/list_fatture_pas',
             'refname':'n_pas'
             },
            {'name':'metodo_pag',
             'title':'Conto Pagamento',
             'type':'str',
             'defvalue':'',
             'maxlen':0,
             'optional':False,
             'tooltip':'Fattura Pagata',
             'ref':'viste/list_conti_disp',
             'refname':'codice_conto'
             },
            {'name':'importo_pag',
             'title':'Importo',
             'type':'float',
             'defvalue':"0",
             'maxlen':2,
             'optional':False,
             'tooltip':'Importo Pagato'
             }
            ]
        
        simpledbmodule.__init__(self,name,"Pagamenti",be,fields,delete=False,table="pagamenti",menu="Acquisti/Pagamenti")
    def gen_commands(self,x):
        simpledbmodule.gen_commands(self,x)

        #x.addcommand("ddtpos/list","Gestisci posizioni",None,fwsel=self.key,update="true")
